/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.from;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.sql.Clob;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import org.noear.snack.ONode;
import org.noear.snack.core.Context;
import org.noear.snack.core.DEFAULTS;
import org.noear.snack.core.Feature;
import org.noear.snack.core.NameValues;
import org.noear.snack.core.NodeEncoderEntity;
import org.noear.snack.core.Options;
import org.noear.snack.core.exts.ClassWrap;
import org.noear.snack.core.exts.EnumWrap;
import org.noear.snack.core.exts.FieldWrap;
import org.noear.snack.core.utils.BeanUtil;
import org.noear.snack.core.utils.DateUtil;
import org.noear.snack.core.utils.StringUtil;
import org.noear.snack.core.utils.TypeUtil;
import org.noear.snack.from.Fromer;

public class ObjectFromer
implements Fromer {
    @Override
    public void handle(Context ctx) {
        ctx.target = this.analyse(ctx.options, ctx.source);
    }

    private ONode analyse(Options opt, Object source) {
        Instant instant;
        ONode rst = new ONode(null, opt);
        if (source == null) {
            return rst;
        }
        Class<?> clz = source.getClass();
        for (NodeEncoderEntity encoder : opt.encoders()) {
            if (!encoder.isEncodable(clz)) continue;
            encoder.encode(source, rst);
            return rst;
        }
        if (source instanceof ONode) {
            rst.val(source);
        } else if (source instanceof String) {
            if (opt.hasFeature(Feature.StringJsonToNode)) {
                String sval = (String)source;
                ONode otmp = null;
                if (sval.startsWith("{") && sval.endsWith("}") || sval.startsWith("[") && sval.endsWith("]")) {
                    otmp = ONode.loadStr(sval, opt);
                }
                if (otmp == null) {
                    rst.val().setString(sval);
                } else {
                    rst.val(otmp);
                }
            } else {
                rst.val().setString((String)source);
            }
        } else if (source instanceof UUID) {
            rst.val().setString(((UUID)source).toString());
        } else if (source instanceof Date) {
            rst.val().setDate((Date)source);
        } else if (source instanceof ZonedDateTime) {
            rst.val().setDate(Date.from(((ZonedDateTime)source).toInstant()));
        } else if (source instanceof OffsetDateTime) {
            rst.val().setDate(Date.from(((OffsetDateTime)source).toInstant()));
        } else if (source instanceof LocalDateTime) {
            instant = ((LocalDateTime)source).atZone(DEFAULTS.DEF_TIME_ZONE.toZoneId()).toInstant();
            rst.val().setDate(new Date(instant.getEpochSecond() * 1000L + (long)(instant.getNano() / 1000000)));
        } else if (source instanceof LocalDate) {
            instant = ((LocalDate)source).atTime(LocalTime.MIN).atZone(DEFAULTS.DEF_TIME_ZONE.toZoneId()).toInstant();
            rst.val().setDate(new Date(instant.getEpochSecond() * 1000L));
        } else if (source instanceof LocalTime) {
            instant = ((LocalTime)source).atDate(LocalDate.of(1970, 1, 1)).atZone(DEFAULTS.DEF_TIME_ZONE.toZoneId()).toInstant();
            rst.val().setDate(new Date(instant.getEpochSecond() * 1000L));
        } else if (source instanceof OffsetTime) {
            instant = ((OffsetTime)source).atDate(LocalDate.of(1970, 1, 1)).toInstant();
            rst.val().setDate(Date.from(instant));
        } else if (source instanceof Boolean) {
            rst.val().setBool((Boolean)source);
        } else if (source instanceof Number) {
            rst.val().setNumber((Number)source);
        } else if (source instanceof Throwable) {
            this.analyseBean(opt, rst, clz, source);
        } else if (source instanceof Properties) {
            this.analyseProps(opt, rst, clz, source);
        } else if (source instanceof NameValues) {
            this.analyseNameValues(opt, rst, clz, source);
        } else if (!this.analyseArray(opt, rst, clz, source)) {
            if (clz.isEnum() || Enum.class.isAssignableFrom(clz)) {
                Enum em = (Enum)source;
                EnumWrap ew = TypeUtil.createEnum(source.getClass());
                Object o = ew.getCustomValue(em);
                if (o != null) {
                    rst.val().set(o);
                } else if (opt.hasFeature(Feature.EnumUsingName)) {
                    rst.val().setString(em.name());
                } else {
                    rst.val().setNumber(em.ordinal());
                }
            } else if (source instanceof Map) {
                if (opt.hasFeature(Feature.WriteClassName)) {
                    this.typeSet(opt, rst, clz);
                }
                rst.asObject();
                Map map = (Map)source;
                for (Object k : map.keySet()) {
                    Object v;
                    if (k == null || (v = map.get(k)) == null && !opt.hasFeature(Feature.SerializeNulls) && !opt.hasFeature(Feature.SerializeMapNullValues)) continue;
                    rst.setNode(k.toString(), this.analyse(opt, v));
                }
            } else if (source instanceof Iterable) {
                rst.asArray();
                ONode ary = rst;
                if (opt.hasFeature(Feature.WriteArrayClassName)) {
                    rst.add(this.typeSet(opt, new ONode(null, opt), clz));
                    ary = rst.addNew().asArray();
                }
                for (Object o : (Iterable)source) {
                    ary.addNode(this.analyse(opt, o));
                }
            } else if (source instanceof Enumeration) {
                rst.asArray();
                Enumeration o = (Enumeration)source;
                while (o.hasMoreElements()) {
                    rst.addNode(this.analyse(opt, o.nextElement()));
                }
            } else {
                String clzName = clz.getName();
                if (clzName.endsWith(".Undefined")) {
                    rst.val().setNull();
                } else if (!this.analyseOther(opt, rst, clz, source) && !clzName.startsWith("jdk.")) {
                    this.analyseBean(opt, rst, clz, source);
                }
            }
        }
        return rst;
    }

    private ONode typeSet(Options cfg, ONode o, Class<?> clz) {
        return o.set(cfg.getTypePropertyName(), clz.getName());
    }

    private boolean analyseArray(Options cfg, ONode rst, Class<?> clz, Object obj) {
        if (obj instanceof Object[]) {
            rst.asArray();
            for (Object o : (Object[])obj) {
                rst.addNode(this.analyse(cfg, o));
            }
        } else if (obj instanceof byte[]) {
            rst.asArray();
            for (byte o : (byte[])obj) {
                rst.addNode(this.analyse(cfg, o));
            }
        } else if (obj instanceof short[]) {
            rst.asArray();
            for (short o : (short[])obj) {
                rst.addNode(this.analyse(cfg, o));
            }
        } else if (obj instanceof int[]) {
            rst.asArray();
            for (int o : (int[])obj) {
                rst.addNode(this.analyse(cfg, o));
            }
        } else if (obj instanceof long[]) {
            rst.asArray();
            for (long o : (long[])obj) {
                rst.addNode(this.analyse(cfg, o));
            }
        } else if (obj instanceof float[]) {
            rst.asArray();
            for (float o : (float[])obj) {
                rst.addNode(this.analyse(cfg, Float.valueOf(o)));
            }
        } else if (obj instanceof double[]) {
            rst.asArray();
            for (double o : (double[])obj) {
                rst.addNode(this.analyse(cfg, o));
            }
        } else if (obj instanceof boolean[]) {
            rst.asArray();
            for (boolean o : (boolean[])obj) {
                rst.addNode(this.analyse(cfg, o));
            }
        } else if (obj instanceof char[]) {
            rst.asArray();
            for (char o : (char[])obj) {
                rst.addNode(this.analyse(cfg, Character.valueOf(o)));
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean analyseProps(Options cfg, ONode rst, Class<?> clz, Object obj) {
        Properties props = (Properties)obj;
        if (props.size() == 0) {
            rst.asNull();
            return true;
        }
        ArrayList keyVector = new ArrayList();
        props.keySet().forEach(k -> {
            if (k instanceof String) {
                keyVector.add((String)k);
            }
        });
        Collections.sort(keyVector);
        if (((String)keyVector.get(0)).startsWith("[")) {
            rst.asArray();
        } else {
            rst.asObject();
        }
        for (String key : keyVector) {
            String val = props.getProperty(key);
            this.analysePropsItem(rst, key, val);
        }
        return true;
    }

    private boolean analyseNameValues(Options cfg, ONode rst, Class<?> clz, Object obj) {
        NameValues props = (NameValues)obj;
        if (props.size() == 0) {
            rst.asNull();
            return true;
        }
        props.sort();
        if (props.get(0).getKey().startsWith("[")) {
            rst.asArray();
        } else {
            rst.asObject();
        }
        for (Map.Entry<String, String> kv : props.getItems()) {
            String key = kv.getKey();
            String val = kv.getValue();
            this.analysePropsItem(rst, key, val);
        }
        return true;
    }

    private void analysePropsItem(ONode rst, String key, String val) {
        String[] keySegments = key.split("\\.");
        ONode n1 = rst;
        for (int i = 0; i < keySegments.length; ++i) {
            String p1 = keySegments[i];
            if (p1.endsWith("]")) {
                String tmp = p1.substring(p1.lastIndexOf(91) + 1, p1.length() - 1);
                p1 = p1.substring(0, p1.lastIndexOf(91));
                if (tmp.length() > 0) {
                    if (StringUtil.isInteger(tmp)) {
                        int idx = Integer.parseInt(tmp);
                        if (p1.length() > 0) {
                            n1 = n1.getOrNew(p1).getOrNew(idx);
                            continue;
                        }
                        n1 = n1.getOrNew(idx);
                        continue;
                    }
                    if (tmp.length() > 2 && (tmp.indexOf(39) == 0 || tmp.indexOf(34) == 0)) {
                        tmp = tmp.substring(1, tmp.length() - 1);
                    }
                    if (p1.length() > 0) {
                        n1 = n1.getOrNew(p1).getOrNew(tmp);
                        continue;
                    }
                    n1 = n1.getOrNew(tmp);
                    continue;
                }
                if (p1.length() > 0) {
                    n1 = n1.getOrNew(p1).addNew();
                    continue;
                }
                n1 = n1.addNew();
                continue;
            }
            n1 = n1.getOrNew(p1);
        }
        n1.val(val);
    }

    private boolean analyseBean(Options cfg, ONode rst, Class<?> clz, Object obj) {
        rst.asObject();
        if (cfg.hasFeature(Feature.WriteClassName)) {
            rst.set(cfg.getTypePropertyName(), clz.getName());
        }
        Collection<FieldWrap> list = ClassWrap.get(clz).fieldAllWraps();
        boolean useGetter = cfg.hasFeature(Feature.UseGetter);
        boolean useOnlyGetter = cfg.hasFeature(Feature.UseOnlyGetter);
        if (useOnlyGetter) {
            useGetter = true;
        }
        for (FieldWrap f : list) {
            if (!f.isSerialize() || useOnlyGetter && !f.hasGetter) continue;
            Object val = f.getValue(obj, useGetter);
            if (val == null) {
                if (!f.isIncNull()) continue;
                if (cfg.hasFeature(Feature.StringNullAsEmpty) && f.type == String.class) {
                    rst.setNode(f.getName(), this.analyse(cfg, ""));
                    continue;
                }
                if (cfg.hasFeature(Feature.BooleanNullAsFalse) && f.type == Boolean.class) {
                    rst.setNode(f.getName(), this.analyse(cfg, false));
                    continue;
                }
                if (cfg.hasFeature(Feature.NumberNullAsZero) && Number.class.isAssignableFrom(f.type)) {
                    if (f.type == Long.class) {
                        rst.setNode(f.getName(), this.analyse(cfg, 0L));
                        continue;
                    }
                    if (f.type == Double.class) {
                        rst.setNode(f.getName(), this.analyse(cfg, 0.0));
                        continue;
                    }
                    if (f.type == Float.class) {
                        rst.setNode(f.getName(), this.analyse(cfg, Float.valueOf(0.0f)));
                        continue;
                    }
                    rst.setNode(f.getName(), this.analyse(cfg, 0));
                    continue;
                }
                if (cfg.hasFeature(Feature.ArrayNullAsEmpty) && (Collection.class.isAssignableFrom(f.type) || f.type.isArray())) {
                    rst.setNode(f.getName(), new ONode(null, cfg).asArray());
                    continue;
                }
                if (!cfg.hasFeature(Feature.SerializeNulls)) continue;
                rst.setNode(f.getName(), new ONode(null, cfg).asValue());
                continue;
            }
            if (val.equals(obj)) continue;
            if (!StringUtil.isEmpty(f.getFormat())) {
                String val2;
                DateTimeFormatter fmt;
                if (val instanceof Date) {
                    String val22 = DateUtil.format((Date)val, f.getFormat(), f.getTimeZone());
                    rst.set(f.getName(), val22);
                    continue;
                }
                if (val instanceof LocalDateTime) {
                    fmt = DateTimeFormatter.ofPattern(f.getFormat());
                    if (f.getTimeZone() != null) {
                        fmt.withZone(f.getTimeZone().toZoneId());
                    }
                    val2 = ((LocalDateTime)val).format(fmt);
                    rst.set(f.getName(), val2);
                    continue;
                }
                if (val instanceof LocalDate) {
                    fmt = DateTimeFormatter.ofPattern(f.getFormat());
                    if (f.getTimeZone() != null) {
                        fmt.withZone(f.getTimeZone().toZoneId());
                    }
                    val2 = ((LocalDate)val).format(fmt);
                    rst.set(f.getName(), val2);
                    continue;
                }
                if (val instanceof LocalTime) {
                    fmt = DateTimeFormatter.ofPattern(f.getFormat());
                    if (f.getTimeZone() != null) {
                        fmt.withZone(f.getTimeZone().toZoneId());
                    }
                    val2 = ((LocalTime)val).format(fmt);
                    rst.set(f.getName(), val2);
                    continue;
                }
                if (val instanceof Number) {
                    DecimalFormat format = new DecimalFormat(f.getFormat());
                    val2 = format.format(val);
                    rst.set(f.getName(), val2);
                    continue;
                }
            }
            if (f.isAsString()) {
                rst.set(f.getName(), val.toString());
                continue;
            }
            rst.setNode(f.getName(), this.analyse(cfg, val));
        }
        return true;
    }

    private boolean analyseOther(Options cfg, ONode rst, Class<?> clz, Object obj) {
        if (obj instanceof SimpleDateFormat) {
            rst.set(cfg.getTypePropertyName(), clz.getName());
            rst.set("val", ((SimpleDateFormat)obj).toPattern());
        } else if (clz == Class.class) {
            rst.val().setString(clz.getName());
        } else if (obj instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)obj;
            InetAddress inetAddress = address.getAddress();
            rst.set("address", inetAddress.getHostAddress());
            rst.set("port", address.getPort());
        } else if (obj instanceof File) {
            rst.val().setString(((File)obj).getPath());
        } else if (obj instanceof InetAddress) {
            rst.val().setString(((InetAddress)obj).getHostAddress());
        } else if (obj instanceof TimeZone) {
            rst.val().setString(((TimeZone)obj).getID());
        } else if (obj instanceof Currency) {
            rst.val().setString(((Currency)obj).getCurrencyCode());
        } else if (obj instanceof Iterator) {
            rst.asArray();
            ((Iterator)obj).forEachRemaining(v -> rst.add(this.analyse(cfg, v)));
        } else if (obj instanceof Map.Entry) {
            Map.Entry kv = (Map.Entry)obj;
            Object k = kv.getKey();
            Object v2 = kv.getValue();
            rst.asObject();
            if (k != null) {
                rst.set(k.toString(), this.analyse(cfg, v2));
            }
        } else if (obj instanceof Calendar) {
            rst.val().setDate(((Calendar)obj).getTime());
        } else if (obj instanceof Clob) {
            rst.val().setString(BeanUtil.clobToString((Clob)obj));
        } else if (obj instanceof Appendable) {
            rst.val().setString(obj.toString());
        } else {
            return false;
        }
        return true;
    }
}

