/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.i18n.integration;

import org.noear.solon.Utils;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.i18n.I18nBundle;
import org.noear.solon.i18n.I18nUtil;
import org.noear.solon.i18n.annotation.I18n;

public final class I18nInterceptor
implements Interceptor {
    public static final I18nInterceptor instance = new I18nInterceptor();

    public Object doIntercept(Invocation inv) throws Throwable {
        Object rst = inv.invoke();
        if (rst instanceof ModelAndView) {
            Context ctx = Context.current();
            I18n anno = (I18n)inv.getMethodAnnotation(I18n.class);
            if (anno == null) {
                anno = (I18n)inv.getTargetAnnotation(I18n.class);
            }
            if (anno != null && ctx != null) {
                ModelAndView mv = (ModelAndView)rst;
                String bundleName = Utils.annoAlias((String)anno.value(), (String)anno.bundle());
                I18nBundle bundle = Utils.isEmpty((String)bundleName) ? I18nUtil.getMessageBundle(ctx) : I18nUtil.getBundle(bundleName, ctx);
                mv.put("i18n", (Object)bundle);
            }
        }
        return rst;
    }
}

