/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jlhttp;

import java.util.concurrent.Executor;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.jlhttp.HTTPServer;
import org.noear.solon.boot.jlhttp.JlHttpContextHandler;
import org.noear.solon.boot.ssl.SslContextFactory;
import org.noear.solon.core.handle.Handler;

public class JlHttpServer
implements ServerLifecycle {
    private HTTPServer server = null;
    private Handler handler;
    private Executor executor;
    private boolean allowSsl = true;

    public void allowSsl(boolean allowSsl) {
        this.allowSsl = allowSsl;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void start(String host, int port) throws Throwable {
        this.server = new HTTPServer();
        if (this.allowSsl && System.getProperty("javax.net.ssl.keyStore") != null) {
            this.server.setServerSocketFactory(SslContextFactory.create().getServerSocketFactory());
        }
        HTTPServer.VirtualHost virtualHost = this.server.getVirtualHost(null);
        virtualHost.setDirectoryIndex(null);
        virtualHost.addContext("/", new JlHttpContextHandler(this.handler), "*");
        this.server.setExecutor(this.executor);
        this.server.setPort(port);
        if (Utils.isNotEmpty((String)host)) {
            this.server.setHost(host);
        }
        this.server.start();
    }

    public void stop() throws Throwable {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }
}

