/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.Collection;
import org.noear.solon.Solon;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.handle.ActionLoader;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerSlots;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.MethodTypeUtil;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.route.Router;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.route.RoutingDefault;
import org.noear.solon.core.route.RoutingTable;
import org.noear.solon.core.route.RoutingTableDefault;
import org.noear.solon.core.util.PathMatcher;

public class RouterDefault
implements Router,
HandlerSlots {
    private final RoutingTable<Handler> table = new RoutingTableDefault<Handler>();

    @Override
    public void caseSensitive(boolean caseSensitive) {
        PathMatcher.setCaseSensitive(caseSensitive);
    }

    @Override
    public void add(String path, MethodType method, int index, Handler handler) {
        RoutingDefault<Handler> routing = new RoutingDefault<Handler>(path, method, index, handler);
        if (path.contains("*") || path.contains("{")) {
            this.table.add(routing);
        } else {
            this.table.add(0, routing);
        }
    }

    @Override
    public void add(BeanWrap controllerWrap) {
        if (controllerWrap != null) {
            ActionLoader al = Solon.app().factoryManager().mvcFactory().createLoader(controllerWrap);
            if (controllerWrap.remoting() && al.mapping() == null) {
                return;
            }
            al.load(this);
        }
    }

    @Override
    public void add(String path, BeanWrap controllerWrap) {
        if (controllerWrap != null) {
            Solon.app().factoryManager().mvcFactory().createLoader(controllerWrap, path, controllerWrap.remoting(), null, true).load(this);
        }
    }

    @Override
    public Handler matchMain(Context ctx) {
        MethodType method;
        String pathNew = ctx.pathNew();
        Result<Handler> result = this.table.matchOneAndStatus(pathNew, method = MethodTypeUtil.valueOf(ctx.method()));
        if (result.getData() != null) {
            ctx.attrSet("ATTR_MAIN_HANDLER", result.getData());
            ctx.attrSet("ATTR_MAIN_STATUS", 200);
        } else {
            ctx.attrSet("ATTR_MAIN_HANDLER", null);
            ctx.attrSet("ATTR_MAIN_STATUS", result.getCode());
        }
        return result.getData();
    }

    @Override
    public Collection<Routing<Handler>> getAll() {
        return this.table.getAll();
    }

    @Override
    public Collection<Routing<Handler>> getBy(String path) {
        return this.table.getBy(path);
    }

    @Override
    public Collection<Routing<Handler>> getBy(Class<?> controllerClz) {
        return this.table.getBy(controllerClz);
    }

    @Override
    public void remove(String pathPrefix) {
        this.table.remove(pathPrefix);
    }

    @Override
    public void remove(Class<?> controllerClz) {
        this.table.remove(controllerClz);
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    @Override
    public void add(String expr, MethodType method, Handler handler) {
        this.add(expr, method, 0, handler);
    }
}

