/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.mapper;

import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.wood.DataItem;
import org.noear.wood.DataList;
import org.noear.wood.DbAccess;
import org.noear.wood.DbContext;
import org.noear.wood.IMapperInvoke;
import org.noear.wood.Variate;
import org.noear.wood.WoodConfig;
import org.noear.wood.annotation.Sql;
import org.noear.wood.cache.ICacheService;
import org.noear.wood.cache.ICacheServiceEx;
import org.noear.wood.mapper.MapperHandler;
import org.noear.wood.utils.StringUtils;
import org.noear.wood.wrap.MethodWrap;

public class MapperInvokeForAnn
implements IMapperInvoke {
    public Object call(Object proxy, DbContext db, String sqlid, Class<?> caller, MethodWrap mWrap, Object[] args) throws Throwable {
        Sql ann = mWrap.method.getAnnotation(Sql.class);
        if (ann == null) {
            return MapperHandler.UOE;
        }
        String _sql = ann.value();
        String _caching = ann.caching();
        String _cacheClear = ann.cacheClear();
        ICacheServiceEx cache_tmp = null;
        if (!StringUtils.isEmpty((String)_caching) && (cache_tmp = (ICacheServiceEx)WoodConfig.libOfCache.get(_caching)) == null) {
            throw new RuntimeException("WoodConfig.libOfCache does not exist:@" + _caching);
        }
        HashMap<String, Object> _map = new HashMap<String, Object>();
        Parameter[] names = mWrap.parameters;
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            if (args[i] == null) continue;
            String key = names[i].getName();
            Object val = args[i];
            if ("_map".equals(key) && val instanceof Map) {
                _map.putAll((Map)val);
                continue;
            }
            _map.put(key, val);
        }
        String sqlUp = "# " + _sql.toUpperCase();
        Object sp = null;
        sp = sqlUp.indexOf("@") > 0 ? db.call(_sql).setMap(_map) : (sqlUp.indexOf("?") > 0 ? db.sql(_sql, args) : db.sql(_sql, new Object[0]));
        ICacheServiceEx cache = cache_tmp;
        if (sqlUp.indexOf(" DELETE ") > 0 || sqlUp.indexOf(" UPDATE ") > 0) {
            int rst = sp.execute();
            if (cache != null && !StringUtils.isEmpty((String)_cacheClear)) {
                Arrays.asList(this.formatTag(_cacheClear, _map).split(",")).forEach(k -> cache.clear(k));
            }
            return rst;
        }
        if (sqlUp.indexOf(" INSERT ") > 0) {
            long rst = sp.insert();
            if (cache != null && !StringUtils.isEmpty((String)_cacheClear)) {
                Arrays.asList(this.formatTag(_cacheClear, _map).split(",")).forEach(k -> cache.clear(k));
            }
            return rst;
        }
        if (sqlUp.indexOf(" SELECT ") > 0) {
            return this.forSelect((DbAccess)sp, _map, mWrap, ann, cache);
        }
        return null;
    }

    private Object forSelect(DbAccess sp, Map<String, Object> map, MethodWrap mWrap, Sql ann, ICacheServiceEx cache) throws Throwable {
        String _cacheTag = ann.cacheTag();
        int _usingCache = ann.usingCache();
        if (cache != null) {
            sp.caching((ICacheService)cache);
            if (_usingCache > 0) {
                sp.usingCache(_usingCache);
            }
            if (!StringUtils.isEmpty((String)_cacheTag)) {
                if ((_cacheTag = this.formatTag(_cacheTag, map)).indexOf("}") < 0) {
                    Arrays.asList(_cacheTag.split(",")).forEach(k -> sp.cacheTag(k));
                } else {
                    String _cacheTag2 = _cacheTag;
                    sp.cacheUsing().usingCache((cu, rst) -> {
                        if (rst instanceof DataItem) {
                            Arrays.asList(this.formatTag(_cacheTag2, ((DataItem)rst).getMap()).split(",")).forEach(k -> sp.cacheTag(k));
                        }
                    });
                }
            }
        }
        Class rst_type = mWrap.returnType;
        Type rst_type2 = mWrap.returnGenericType;
        String rst_type_str = rst_type.getName();
        String rst_type2_str = null;
        if (DataItem.class.isAssignableFrom(rst_type)) {
            return sp.getDataItem();
        }
        if (DataList.class.isAssignableFrom(rst_type)) {
            return sp.getDataList();
        }
        if (Map.class.isAssignableFrom(rst_type)) {
            return sp.getMap();
        }
        if (Collection.class.isAssignableFrom(rst_type)) {
            rst_type2_str = (rst_type2 = ((ParameterizedType)rst_type2).getActualTypeArguments()[0]).getTypeName();
            if (!rst_type2_str.startsWith("java.")) {
                Class rst_clz2 = (Class)rst_type2;
                return sp.getList(rst_clz2);
            }
            if (rst_type2_str.indexOf("Map") > 0) {
                return sp.getMapList();
            }
            return sp.getDataList().toArray(0);
        }
        if (!rst_type_str.startsWith("java") && rst_type_str.indexOf(".") > 0) {
            return sp.getItem(rst_type);
        }
        Variate val = sp.getVariate();
        if (Long.class == rst_type || rst_type == Long.TYPE) {
            return val.longValue(0L);
        }
        if (Integer.class == rst_type || rst_type == Integer.TYPE) {
            return val.intValue(0);
        }
        return val.getValue();
    }

    private String formatTag(String tags, Map map) {
        String tags2 = tags;
        Pattern pattern = Pattern.compile("\\$\\{(\\w+)\\}");
        Matcher m = pattern.matcher(tags);
        while (m.find()) {
            String mark = m.group(0);
            String name = m.group(1);
            if (!map.containsKey(name)) continue;
            String val = String.valueOf(map.get(name));
            tags2 = tags2.replace(mark, val);
        }
        return tags2;
    }
}

