/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.noear.wood.Command;
import org.noear.wood.DataItem;
import org.noear.wood.DataReaderForEntity;
import org.noear.wood.IDataReader;
import org.noear.wood.SQLer;

public class DataReader
implements IDataReader<DataItem> {
    private final Command cmd;
    private final SQLer sqLer;
    private final ResultSet rset;
    private final ResultSetMetaData rsetMeta;

    public DataReader(SQLer sqLer, Command cmd, ResultSet rset) throws SQLException {
        this.cmd = cmd;
        this.sqLer = sqLer;
        this.rset = rset;
        this.rsetMeta = rset.getMetaData();
    }

    @Override
    public void close() throws Exception {
        this.sqLer.tryClose();
    }

    @Override
    public DataItem next() throws SQLException {
        if (this.rset != null && this.rset.next()) {
            try {
                DataItem row = new DataItem();
                int len = this.rsetMeta.getColumnCount();
                for (int i = 1; i <= len; ++i) {
                    row.set(this.rsetMeta.getColumnLabel(i), this.getObject(i));
                }
                return row;
            }
            catch (SQLException ex) {
                this.cmd.context.runExceptionEvent(this.cmd, ex);
                throw ex;
            }
        }
        return null;
    }

    private Object getObject(int idx) throws SQLException {
        return this.cmd.context.getDialect().preChange(this.rset.getObject(idx));
    }

    public <T> DataReaderForEntity<T> toEntityReader(Class<T> cls) {
        return new DataReaderForEntity<T>(this, cls);
    }
}

