/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.noear.wood.Command;
import org.noear.wood.DataItem;
import org.noear.wood.DataList;
import org.noear.wood.DataReader;
import org.noear.wood.DbContext;
import org.noear.wood.IQuery;
import org.noear.wood.IWoodKey;
import org.noear.wood.SQLer;
import org.noear.wood.VarHolder;
import org.noear.wood.Variate;
import org.noear.wood.WoodConfig;
import org.noear.wood.cache.CacheUsing;
import org.noear.wood.cache.ICacheService;
import org.noear.wood.ext.Act1;
import org.noear.wood.ext.Act2;

public abstract class DbAccess<T extends DbAccess>
implements IWoodKey,
IQuery,
Serializable {
    public String commandText = null;
    public DbContext context;
    public List<Object> paramS = new ArrayList<Object>();
    private Act1<Command> onCommandExpr = null;
    protected String _woodKey;
    private int _isLog;
    protected CacheUsing _cache = null;

    protected abstract Command getCommand() throws SQLException;

    protected abstract String getCommandID();

    public T onCommandBuilt(Act1<Command> expr) {
        this.onCommandExpr = expr;
        return (T)this;
    }

    protected void runCommandBuiltEvent(Command cmd) {
        cmd.isLog = this._isLog;
        if (this.onCommandExpr != null) {
            this.onCommandExpr.run(cmd);
        }
        cmd.context.runCommandBuiltEvent(cmd);
    }

    public DbAccess(DbContext context) {
        this.context = context;
    }

    @Override
    public String getWoodKey() {
        return this.buildWoodKey(this.paramS);
    }

    protected String buildWoodKey(Collection<Object> args) {
        if (this._woodKey == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getCommandID()).append(":");
            for (Object p : args) {
                sb.append("_").append(p);
            }
            this._woodKey = sb.toString();
        }
        return this._woodKey;
    }

    protected void doSet(String name, Object value) {
        this.paramS.add(value);
    }

    public T log(boolean isLog) {
        this._isLog = isLog ? 1 : -1;
        return (T)this;
    }

    public long insert() throws SQLException {
        Command cmd = this.getCommand();
        return new SQLer(cmd).insert();
    }

    public int update() throws SQLException {
        return this.execute();
    }

    public int delete() throws SQLException {
        return this.execute();
    }

    public int execute() throws SQLException {
        Command cmd = this.getCommand();
        return new SQLer(cmd).execute();
    }

    public int[] executeBatch() throws SQLException {
        Command cmd = this.getCommand();
        cmd.isBatch = true;
        return new SQLer(cmd).executeBatch();
    }

    @Override
    public long getCount() throws SQLException {
        return this.getVariate().longValue(0L);
    }

    @Override
    public Object getValue() throws SQLException {
        return this.getVariate().getValue();
    }

    @Override
    public <T> T getValue(T def) throws SQLException {
        return this.getVariate().value(def);
    }

    @Override
    public Variate getVariate() throws SQLException {
        return this.getVariate(null);
    }

    @Override
    public Variate getVariate(Act2<CacheUsing, Variate> cacheCondition) throws SQLException {
        Variate rst;
        Command cmd = this.getCommand();
        if (this._cache == null) {
            rst = new SQLer(cmd).getVariate();
        } else {
            this._cache.usingCache(cacheCondition);
            rst = this._cache.getEx(this.getWoodKey(), Variate.class, () -> new SQLer(cmd).getVariate());
        }
        if (rst == null) {
            return new Variate();
        }
        return rst;
    }

    @Override
    public <T> List<T> getArray(String column) throws SQLException {
        return this.getDataList().toArray(column);
    }

    @Override
    public <T> List<T> getArray(int columnIndex) throws SQLException {
        return this.getDataList().toArray(columnIndex);
    }

    @Override
    public <T> List<T> getList(Class<T> cls) throws SQLException {
        return this.getDataList().toEntityList(cls);
    }

    @Override
    public <T> List<T> getList(Class<T> cls, Act2<CacheUsing, List<T>> cacheCondition) throws SQLException {
        if (cacheCondition == null) {
            return this.getList(cls);
        }
        VarHolder _tmp = new VarHolder();
        DataList list = this.getDataList((cu, dl) -> {
            _tmp.value = dl.toEntityList(cls);
            cacheCondition.run((CacheUsing)cu, (List)_tmp.value);
        });
        if (_tmp.value == null) {
            return list.toEntityList(cls);
        }
        return (List)_tmp.value;
    }

    @Override
    public <T> T getItem(Class<T> cls) throws SQLException {
        DataItem item = this.getDataItem();
        if (item.count() == 0 && WoodConfig.isSelectItemEmptyAsNull) {
            return null;
        }
        return item.toEntity(cls);
    }

    @Override
    public <T> T getItem(Class<T> cls, Act2<CacheUsing, T> cacheCondition) throws SQLException {
        if (cacheCondition == null) {
            return this.getItem(cls);
        }
        VarHolder _tmp = new VarHolder();
        DataItem item = this.getDataItem((cu, di) -> {
            _tmp.value = di.toEntity(cls);
            cacheCondition.run((CacheUsing)cu, _tmp.value);
        });
        if (item.count() == 0 && WoodConfig.isSelectItemEmptyAsNull) {
            return null;
        }
        if (_tmp.value == null) {
            return item.toEntity(cls);
        }
        return _tmp.value;
    }

    @Override
    public DataList getDataList() throws SQLException {
        return this.getDataList(null);
    }

    @Override
    public DataList getDataList(Act2<CacheUsing, DataList> cacheCondition) throws SQLException {
        DataList rst;
        Command cmd = this.getCommand();
        if (this._cache == null) {
            rst = new SQLer(cmd).getTable();
        } else {
            this._cache.usingCache(cacheCondition);
            rst = this._cache.getEx(this.getWoodKey(), DataList.class, () -> new SQLer(cmd).getTable());
        }
        if (rst == null) {
            return new DataList();
        }
        return rst;
    }

    @Override
    public DataReader getDataReader(int fetchSize) throws SQLException {
        Command cmd = this.getCommand();
        return new SQLer(cmd).getReader(fetchSize);
    }

    @Override
    public List<Map<String, Object>> getMapList() throws SQLException {
        return this.getDataList().getMapList();
    }

    @Override
    public DataItem getDataItem() throws SQLException {
        return this.getDataItem(null);
    }

    @Override
    public DataItem getDataItem(Act2<CacheUsing, DataItem> cacheCondition) throws SQLException {
        DataItem rst;
        Command cmd = this.getCommand();
        if (this._cache == null) {
            rst = new SQLer(cmd).getRow();
        } else {
            this._cache.usingCache(cacheCondition);
            rst = this._cache.getEx(this.getWoodKey(), DataItem.class, () -> new SQLer(cmd).getRow());
        }
        if (rst == null) {
            return new DataItem();
        }
        return rst;
    }

    @Override
    public Map<String, Object> getMap() throws SQLException {
        return this.getDataItem().getMap();
    }

    public CacheUsing cacheUsing() {
        return this._cache;
    }

    @Override
    public IQuery caching(ICacheService service) {
        this._cache = new CacheUsing(service);
        return this;
    }

    @Override
    public IQuery usingCache(boolean isCache) {
        this._cache.usingCache(isCache);
        return this;
    }

    @Override
    public IQuery usingCache(int seconds) {
        this._cache.usingCache(seconds);
        return this;
    }

    @Override
    public IQuery cacheTag(String tag) {
        this._cache.cacheTag(tag);
        return this;
    }

    protected T cache(CacheUsing cacheUsing) {
        this._cache = cacheUsing;
        return (T)this;
    }
}

