/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.noear.wood.WoodConfig;
import org.noear.wood.dialect.DbClickHouseDialect;
import org.noear.wood.dialect.DbDb2Dialect;
import org.noear.wood.dialect.DbDialect;
import org.noear.wood.dialect.DbDuckDbDialect;
import org.noear.wood.dialect.DbH2Dialect;
import org.noear.wood.dialect.DbMySQLDialect;
import org.noear.wood.dialect.DbOracleDialect;
import org.noear.wood.dialect.DbPhoenixDialect;
import org.noear.wood.dialect.DbPostgreSQLDialect;
import org.noear.wood.dialect.DbPrestoDialect;
import org.noear.wood.dialect.DbSQLServerDialect;
import org.noear.wood.dialect.DbSQLiteDialect;
import org.noear.wood.ext.Act1Ex;
import org.noear.wood.wrap.DbType;
import org.noear.wood.wrap.TableWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbContextMetaData
implements Closeable {
    static final Logger log = LoggerFactory.getLogger(DbContextMetaData.class);
    private String schema;
    private String catalog;
    private String productName;
    private String productVersion;
    private String url;
    private transient DataSource dataSource;
    private transient Map<String, TableWrap> tableAll;
    private transient DbType type = DbType.Unknown;
    private transient DbDialect dialect;
    protected transient DatabaseMetaData real;
    public final transient ReentrantLock SYNC_LOCK = new ReentrantLock();

    public DbContextMetaData() {
    }

    public DbContextMetaData(DataSource dataSource) {
        this(dataSource, null);
    }

    public DbContextMetaData(DataSource dataSource, String schema) {
        if (dataSource == null) {
            throw new IllegalArgumentException("Parameter dataSource cannot be null");
        }
        this.dataSource = dataSource;
        this.schema = schema;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public DatabaseMetaData getReal() {
        return this.real;
    }

    public String getUrl() {
        return this.url;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public Connection getConnection() throws SQLException {
        return WoodConfig.connectionFactory.getConnection(this.getDataSource());
    }

    public Connection getMetaConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    public String getSchema() {
        return this.schema;
    }

    protected void setSchema(String schema) {
        this.schema = schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public DbType getType() {
        this.init();
        return this.type;
    }

    public void setType(DbType type) {
        this.init();
        this.type = type;
    }

    public DbDialect getDialect() {
        this.init();
        return this.dialect;
    }

    public void setDialect(DbDialect dialect) {
        this.init();
        this.dialect = dialect;
    }

    public Collection<TableWrap> getTableAll() {
        this.init();
        this.initTables();
        return this.tableAll.values();
    }

    public boolean hasTableColumn(String tableName, String columnName, boolean refresh) {
        TableWrap tmp = this.getTable(tableName);
        if (tmp != null) {
            if (refresh) {
                tmp.refresh();
            }
            return tmp.hasColumn(columnName);
        }
        return false;
    }

    public TableWrap getTable(String tableName) {
        this.init();
        this.initTables();
        return this.tableAll.get(tableName.toLowerCase());
    }

    public String getTablePk1(String tableName) {
        TableWrap tw = this.getTable(tableName);
        return tw == null ? null : tw.getPk1();
    }

    public DbContextMetaData refresh() {
        this.SYNC_LOCK.lock();
        try {
            this.initTablesDo();
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
        return this;
    }

    @Deprecated
    public void refreshTables() {
        this.refresh();
    }

    public boolean init() {
        if (this.dialect != null) {
            return true;
        }
        this.SYNC_LOCK.lock();
        try {
            if (this.dialect != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.initDo();
            return bl;
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    private void initPrintln(String x, boolean warn) {
        if (warn) {
            if (this.schema == null) {
                log.warn("[Wood] Init: " + x);
            } else {
                log.warn("[Wood] Init: " + x + " - " + this.schema);
            }
        } else if (this.schema == null) {
            log.debug("[Wood] Init: " + x);
        } else {
            log.debug("[Wood] Init: " + x + " - " + this.schema);
        }
    }

    private boolean initDo() {
        this.initPrintln("The db metadata dialect", false);
        return this.openMetaConnection(conn -> {
            this.real = conn.getMetaData();
            this.url = this.real.getURL();
            this.productName = this.real.getDatabaseProductName();
            this.productVersion = this.real.getDatabaseProductVersion();
            if (this.dialect == null) {
                this.setDatabaseType(this.url);
                this.setSchema((Connection)conn);
            }
        });
    }

    private void setDatabaseType(String jdbcUrl) {
        if (jdbcUrl != null) {
            String pn = jdbcUrl.toLowerCase().replace(" ", "");
            if (pn.startsWith("jdbc:mysql:")) {
                this.type = DbType.MySQL;
                this.dialect = new DbMySQLDialect();
            } else if (pn.startsWith("jdbc:mariadb:")) {
                this.type = DbType.MariaDB;
                this.dialect = new DbMySQLDialect();
            } else if (pn.startsWith("jdbc:sqlserver:")) {
                this.type = DbType.SQLServer;
                this.dialect = new DbSQLServerDialect();
            } else if (pn.startsWith("jdbc:oracle:")) {
                this.type = DbType.Oracle;
                this.dialect = new DbOracleDialect();
            } else if (pn.startsWith("jdbc:postgresql:")) {
                this.type = DbType.PostgreSQL;
                this.dialect = new DbPostgreSQLDialect();
            } else if (pn.startsWith("jdbc:db2:")) {
                this.type = DbType.DB2;
                this.dialect = new DbDb2Dialect();
            } else if (pn.startsWith("jdbc:sqlite:")) {
                this.type = DbType.SQLite;
                this.dialect = new DbSQLiteDialect();
            } else if (pn.startsWith("jdbc:h2:")) {
                this.type = DbType.H2;
                this.dialect = new DbH2Dialect();
            } else if (pn.startsWith("jdbc:phoenix:")) {
                this.type = DbType.Phoenix;
                this.dialect = new DbPhoenixDialect();
            } else if (pn.startsWith("jdbc:clickhouse:")) {
                this.type = DbType.ClickHouse;
                this.dialect = new DbClickHouseDialect();
            } else if (pn.startsWith("jdbc:presto:")) {
                this.type = DbType.Presto;
                this.dialect = new DbPrestoDialect();
            } else if (pn.startsWith("jdbc:duckdb:")) {
                this.type = DbType.DuckDb;
                this.dialect = new DbDuckDbDialect();
            } else {
                this.dialect = new DbMySQLDialect();
            }
        } else {
            this.type = DbType.MySQL;
            this.dialect = new DbMySQLDialect();
        }
    }

    private void setSchema(Connection conn) throws SQLException {
        try {
            this.catalog = conn.getCatalog();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this.schema != null) {
            return;
        }
        try {
            this.schema = conn.getSchema();
            if (this.schema == null) {
                this.schema = this.catalog;
            }
        }
        catch (Throwable e) {
            switch (this.type) {
                case PostgreSQL: {
                    this.schema = "public";
                    break;
                }
                case H2: {
                    this.schema = "PUBLIC";
                    break;
                }
                case SQLServer: {
                    this.schema = "dbo";
                }
                case Oracle: {
                    this.schema = this.real.getUserName();
                }
            }
        }
    }

    private void initTables() {
        if (this.tableAll != null) {
            return;
        }
        this.SYNC_LOCK.lock();
        try {
            if (this.tableAll != null) {
                return;
            }
            this.initTablesDo();
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    private void initTablesDo() {
        this.initPrintln("The db metadata tables", false);
        try {
            this.initTablesLoadDo(this.real);
        }
        catch (Throwable e) {
            this.initPrintln("The db metadata-tables is loaded failed", true);
            e.printStackTrace();
        }
    }

    private void initTablesLoadDo(DatabaseMetaData md) throws SQLException {
        this.tableAll = new HashMap<String, TableWrap>();
        try (ResultSet rs = this.getDialect().getTables(md, this.catalog, this.schema);){
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                String remarks = rs.getString("REMARKS");
                TableWrap tWrap = new TableWrap(this, name, remarks);
                this.tableAll.put(name.toLowerCase(), tWrap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openMetaConnection(Act1Ex<Connection, Exception> callback) {
        boolean bl;
        Connection conn = null;
        try {
            this.initPrintln("The db metadata connectivity...", false);
            conn = this.getMetaConnection();
            callback.run(conn);
            this.initPrintln("The db metadata is loaded successfully", false);
            bl = true;
            if (conn == null) return bl;
        }
        catch (Throwable ex) {
            try {
                this.initPrintln("The db metadata is loaded failed", true);
                ex.printStackTrace();
                boolean bl2 = false;
                return bl2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        try {
            conn.close();
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public void close() throws IOException {
        if (this.dataSource != null && this.dataSource instanceof Closeable) {
            ((Closeable)((Object)this.dataSource)).close();
        }
    }
}

