/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.noear.wood.Command;
import org.noear.wood.DataItem;
import org.noear.wood.DataList;
import org.noear.wood.DataReader;
import org.noear.wood.IBinder;
import org.noear.wood.Variate;
import org.noear.wood.WoodConfig;

class SQLer {
    private final Command cmd;
    private ResultSet rset;
    private PreparedStatement stmt;
    private Connection conn;

    protected void tryClose() {
        try {
            if (this.rset != null) {
                this.rset.close();
                this.rset = null;
            }
        }
        catch (Exception ex) {
            this.cmd.context.runExceptionEvent(this.cmd, ex);
        }
        try {
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
        }
        catch (Exception ex) {
            this.cmd.context.runExceptionEvent(this.cmd, ex);
        }
        try {
            if (this.conn != null) {
                if (this.conn.getAutoCommit()) {
                    this.conn.close();
                }
                this.conn = null;
            }
        }
        catch (Exception ex) {
            this.cmd.context.runExceptionEvent(this.cmd, ex);
        }
    }

    public SQLer(Command cmd) {
        this.cmd = cmd;
    }

    private Object getObject(String key) throws SQLException {
        return this.cmd.context.getDialect().preChange(this.rset.getObject(key));
    }

    private Object getObject(int idx) throws SQLException {
        return this.cmd.context.getDialect().preChange(this.rset.getObject(idx));
    }

    public Variate getVariate() throws SQLException {
        if (this.cmd.context.isCompilationMode()) {
            return null;
        }
        try {
            this.rset = this.query(false, 0);
            if (this.rset != null && this.rset.next()) {
                Variate variate = new Variate(null, this.getObject(1));
                return variate;
            }
            Variate variate = null;
            return variate;
        }
        catch (SQLException ex) {
            this.cmd.context.runExceptionEvent(this.cmd, ex);
            throw ex;
        }
        finally {
            this.tryClose();
        }
    }

    public <T extends IBinder> T getItem(T model) throws SQLException {
        if (this.cmd.context.isCompilationMode()) {
            return null;
        }
        try {
            this.rset = this.query(false, 0);
            if (this.rset != null && this.rset.next()) {
                model.bind(key -> {
                    try {
                        return new Variate(key, this.getObject(key));
                    }
                    catch (SQLException ex) {
                        this.cmd.context.runExceptionEvent(this.cmd, ex);
                        return new Variate(key, null);
                    }
                });
                T t = model;
                return t;
            }
            T t = null;
            return t;
        }
        catch (SQLException ex) {
            this.cmd.context.runExceptionEvent(this.cmd, ex);
            throw ex;
        }
        finally {
            this.tryClose();
        }
    }

    public <T extends IBinder> List<T> getList(T model) throws SQLException {
        if (this.cmd.context.isCompilationMode()) {
            return null;
        }
        try {
            ArrayList<IBinder> arrayList;
            ArrayList<IBinder> list = new ArrayList<IBinder>();
            this.rset = this.query(false, 0);
            while (this.rset != null && this.rset.next()) {
                IBinder item = model.clone();
                if (WoodConfig.isDebug && !model.getClass().isInstance(item)) {
                    throw new SQLException(model.getClass() + " clone error(" + item.getClass() + ")");
                }
                item.bind(key -> {
                    try {
                        return new Variate(key, this.getObject(key));
                    }
                    catch (SQLException ex) {
                        this.cmd.context.runExceptionEvent(this.cmd, ex);
                        return new Variate(key, null);
                    }
                });
                list.add(item);
            }
            if (list.size() > 0) {
                arrayList = list;
                return arrayList;
            }
            arrayList = null;
            return arrayList;
        }
        catch (SQLException ex) {
            this.cmd.context.runExceptionEvent(this.cmd, ex);
            throw ex;
        }
        finally {
            this.tryClose();
        }
    }

    public DataItem getRow() throws SQLException {
        if (this.cmd.context.isCompilationMode()) {
            return null;
        }
        try {
            DataItem row = new DataItem();
            this.rset = this.query(false, 0);
            ResultSetMetaData meta = this.rset.getMetaData();
            if (this.rset != null && this.rset.next()) {
                int len = meta.getColumnCount();
                for (int i = 1; i <= len; ++i) {
                    row.set(meta.getColumnLabel(i), this.getObject(i));
                }
            }
            if (row.count() > 0) {
                DataItem dataItem = row;
                return dataItem;
            }
            DataItem dataItem = null;
            return dataItem;
        }
        catch (SQLException ex) {
            this.cmd.context.runExceptionEvent(this.cmd, ex);
            throw ex;
        }
        finally {
            this.tryClose();
        }
    }

    public DataList getTable() throws SQLException {
        if (this.cmd.context.isCompilationMode()) {
            return null;
        }
        try {
            DataList dataList;
            DataList table = new DataList();
            this.rset = this.query(false, 0);
            ResultSetMetaData meta = this.rset.getMetaData();
            while (this.rset != null && this.rset.next()) {
                DataItem row = new DataItem();
                int len = meta.getColumnCount();
                for (int i = 1; i <= len; ++i) {
                    row.set(meta.getColumnLabel(i), this.getObject(i));
                }
                table.addRow(row);
            }
            if (table.getRowCount() > 0) {
                dataList = table;
                return dataList;
            }
            dataList = null;
            return dataList;
        }
        catch (SQLException ex) {
            this.cmd.context.runExceptionEvent(this.cmd, ex);
            throw ex;
        }
        finally {
            this.tryClose();
        }
    }

    public DataReader getReader(int fetchSize) throws SQLException {
        if (this.cmd.context.isCompilationMode()) {
            return null;
        }
        try {
            this.rset = this.query(true, fetchSize);
            return new DataReader(this, this.cmd, this.rset);
        }
        catch (SQLException ex) {
            this.cmd.context.runExceptionEvent(this.cmd, ex);
            this.tryClose();
            throw ex;
        }
    }

    public int execute() throws SQLException {
        if (this.cmd.context.isCompilationMode()) {
            return 0;
        }
        try {
            if (!this.buildCMD(false, false, 0)) {
                int n = -1;
                return n;
            }
            int rst = this.stmt.executeUpdate();
            this.cmd.affectRow = new long[]{rst};
            int n = rst;
            return n;
        }
        catch (SQLException ex) {
            this.cmd.context.runExceptionEvent(this.cmd, ex);
            throw ex;
        }
        finally {
            this.cmd.context.runExecuteAftEvent(this.cmd);
            this.tryClose();
        }
    }

    public int[] executeBatch() throws SQLException {
        if (this.cmd.context.isCompilationMode()) {
            return null;
        }
        try {
            if (!this.buildCMD0(false, false, 0)) {
                int[] nArray = null;
                return nArray;
            }
            for (Object data : this.cmd.paramS) {
                Object[] ary;
                int idx = 1;
                for (Object v : ary = (Object[])data) {
                    WoodConfig.typeConverter.filling(this.stmt, idx, v);
                    ++idx;
                }
                this.stmt.addBatch();
            }
            int[] rst = this.stmt.executeBatch();
            this.cmd.affectRow = new long[rst.length];
            for (int i = 0; i < rst.length; ++i) {
                this.cmd.affectRow[i] = rst[i];
            }
            int[] nArray = rst;
            return nArray;
        }
        catch (SQLException ex) {
            this.cmd.context.runExceptionEvent(this.cmd, ex);
            throw ex;
        }
        finally {
            this.cmd.context.runExecuteAftEvent(this.cmd);
            this.tryClose();
        }
    }

    public long insert() throws SQLException {
        if (this.cmd.context.isCompilationMode()) {
            return 0L;
        }
        try {
            Object tmp22;
            if (!this.buildCMD(true, false, 0)) {
                long l = -1L;
                return l;
            }
            this.stmt.executeUpdate();
            if (this.cmd.context.getDialect().supportsInsertGeneratedKey()) {
                try {
                    this.rset = this.stmt.getGeneratedKeys();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.rset != null && this.rset.next() && (tmp22 = this.getObject(1)) instanceof Number) {
                long l = ((Number)tmp22).longValue();
                this.cmd.affectRow = new long[]{l};
                long l2 = l;
                return l2;
            }
            long tmp22 = 0L;
            return tmp22;
        }
        catch (SQLException ex) {
            this.cmd.context.runExceptionEvent(this.cmd, ex);
            throw ex;
        }
        finally {
            this.cmd.context.runExecuteAftEvent(this.cmd);
            this.tryClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet query(boolean isStream, int fetchSize) throws SQLException {
        if (!this.buildCMD(false, isStream, fetchSize)) {
            return null;
        }
        try {
            ResultSet resultSet = this.stmt.executeQuery();
            return resultSet;
        }
        finally {
            this.cmd.context.runExecuteAftEvent(this.cmd);
        }
    }

    private boolean buildCMD(boolean isInsert, boolean isStream, int fetchSize) throws SQLException {
        if (!this.buildCMD0(isInsert, isStream, fetchSize)) {
            return false;
        }
        int idx = 1;
        for (Object v : this.cmd.paramS) {
            WoodConfig.typeConverter.filling(this.stmt, idx, v);
            ++idx;
        }
        return true;
    }

    private boolean buildCMD0(boolean isInsert, boolean isStream, int fetchSize) throws SQLException {
        if (!this.cmd.context.runExecuteBefEvent(this.cmd)) {
            return false;
        }
        Connection c = this.cmd.tran == null ? (this.conn = this.cmd.context.getConnection()) : this.cmd.tran.getConnection(this.cmd.context);
        if (this.cmd.text.indexOf("{call") >= 0) {
            this.stmt = c.prepareCall(this.cmd.fullText());
        } else if (isStream) {
            this.stmt = c.prepareStatement(this.cmd.fullText(), 1003, 1007);
            if (fetchSize > 0) {
                this.stmt.setFetchSize(fetchSize);
            } else {
                this.stmt.setFetchSize(Integer.MIN_VALUE);
            }
        } else {
            this.stmt = isInsert && this.cmd.context.getDialect().supportsInsertGeneratedKey() ? c.prepareStatement(this.cmd.fullText(), 1) : c.prepareStatement(this.cmd.fullText());
        }
        this.cmd.context.runExecuteStmEvent(this.cmd, this.stmt);
        return true;
    }
}

