/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.wood.TmlBlock;
import org.noear.wood.TmlMark;
import org.noear.wood.utils.StringUtils;

public class TmlAnalyzer {
    private static final ReentrantLock SYNC_LOCK = new ReentrantLock();
    private static Map<String, TmlBlock> libs = new HashMap<String, TmlBlock>();

    public static TmlBlock get(String tml, Map<String, Object> args) {
        TmlBlock block = libs.get(tml);
        if (block == null) {
            SYNC_LOCK.lock();
            try {
                block = libs.get(tml);
                if (block == null) {
                    block = TmlAnalyzer.build(tml, args);
                    libs.put(tml, block);
                }
            }
            finally {
                SYNC_LOCK.unlock();
            }
        }
        return block;
    }

    private static TmlBlock build(String tml, Map<String, Object> args) {
        TmlBlock cache = new TmlBlock();
        cache.sql = tml;
        cache.sql2 = tml;
        cache.marks = TmlAnalyzer.parse(tml);
        HashMap<String, String> tmpList = new HashMap<String, String>();
        for (TmlMark tm : cache.marks) {
            Object val = args.get(tm.name);
            if (val instanceof Iterable) {
                tmpList.put(tm.mark, tm.mark);
                continue;
            }
            if (tm.mark.startsWith("@")) {
                tmpList.put(tm.mark, "?");
                continue;
            }
            String valStr = val == null ? "" : val.toString();
            tmpList.put(tm.mark, valStr);
        }
        ArrayList keyList = new ArrayList(tmpList.keySet());
        Collections.sort(keyList, (o1, o2) -> {
            int len = o2.length() - o1.length();
            if (len > 0) {
                return 1;
            }
            if (len < 0) {
                return -1;
            }
            return 0;
        });
        for (String key : keyList) {
            cache.sql2 = cache.sql2.replace(key, (CharSequence)tmpList.get(key));
        }
        return cache;
    }

    private static List<TmlMark> parse(String tml) {
        ArrayList<TmlMark> marks = new ArrayList<TmlMark>();
        Pattern pattern = Pattern.compile("@(\\w+)|[@\\$]{1}\\{(\\w+)\\}");
        Matcher m = pattern.matcher(tml);
        while (m.find()) {
            String mark = m.group(0);
            String name = m.group(1);
            if (StringUtils.isEmpty(name)) {
                name = m.group(2);
            }
            marks.add(new TmlMark(mark, name));
        }
        return marks;
    }
}

