/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.wrap;

import org.noear.wood.DbContext;
import org.noear.wood.dialect.DbDialect;

public class DbFormater {
    protected DbContext ctx;

    public DbFormater(DbContext ctx) {
        this.ctx = ctx;
    }

    public DbDialect dba() {
        return this.ctx.getDialect();
    }

    public String formatSchema(String name) {
        return this.dba().schemaFormat(name);
    }

    public String formatColumn(String name) {
        if (this.dba().excludeFormat(name) || name.indexOf(")") > 0) {
            return name;
        }
        return this.dba().columnFormat(name);
    }

    public String formatMultipleColumns(String columns) {
        if (columns.indexOf(")") > 0) {
            return columns;
        }
        StringBuilder sb = new StringBuilder();
        String[] ss = columns.split(",");
        int len = ss.length;
        for (int i = 0; i < len; ++i) {
            String name = ss[i].trim();
            if (name.indexOf(" ") > 0) {
                int idx = name.indexOf(" ");
                String left = name.substring(0, idx).trim();
                String left_up = left.toUpperCase();
                if ("ALL".equals(left_up) || "DISTINCT".equals(left_up) || "DISTINCTROW".equals(left_up) || "TOP".equals(left_up)) {
                    sb.append(name).append(",");
                    continue;
                }
                sb.append(this.format_column_do(left)).append(name.substring(idx)).append(",");
                continue;
            }
            sb.append(this.format_column_do(name)).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String format_column_do(String name) {
        if (this.dba().excludeFormat(name) || name.equals("*") || name.indexOf(")") > 0) {
            return name;
        }
        return this.dba().columnFormat(name);
    }

    public String formatCondition(String condition) {
        return condition;
    }

    public String formatTable(String name) {
        if (this.dba().excludeFormat(name) || name.indexOf("(") > 0) {
            return name;
        }
        if (name.indexOf(" ") < 0) {
            return this.dba().tableFormat(name);
        }
        int idx = name.indexOf(" ");
        return this.dba().tableFormat(name.substring(0, idx)) + " " + this.dba().schemaFormat(name.substring(idx + 1));
    }
}

