/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.utils;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import org.noear.wood.utils.StringUtils;

public class IOUtils {
    public static void fileWrite(File file, String content) throws Exception {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(content);
        }
    }

    public static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static <T> T loadEntity(String className) {
        try {
            Class<?> clz = Class.forName(className);
            if (clz != null) {
                return (T)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static URL getResource(String name) {
        URL url = IOUtils.class.getResource(name);
        if (url == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            url = loader != null ? loader.getResource(name) : ClassLoader.getSystemResource(name);
        }
        return url;
    }

    public static Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> urls = IOUtils.class.getClassLoader().getResources(name);
        if (urls == null || !urls.hasMoreElements()) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            urls = loader != null ? loader.getResources(name) : ClassLoader.getSystemResources(name);
        }
        return urls;
    }

    public static String transferToString(InputStream ins) throws IOException {
        return IOUtils.transferToString(ins, "utf-8");
    }

    public static String transferToString(InputStream ins, String charset) throws IOException {
        if (ins == null) {
            return null;
        }
        ByteArrayOutputStream outs = IOUtils.transferTo(ins, new ByteArrayOutputStream());
        if (StringUtils.isEmpty(charset)) {
            return outs.toString();
        }
        return outs.toString(charset);
    }

    public static byte[] transferToBytes(InputStream ins) throws IOException {
        if (ins == null) {
            return null;
        }
        return IOUtils.transferTo(ins, new ByteArrayOutputStream()).toByteArray();
    }

    public static <T extends OutputStream> T transferTo(InputStream ins, T out) throws IOException {
        if (ins == null || out == null) {
            return null;
        }
        int len = 0;
        byte[] buf = new byte[512];
        while ((len = ins.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        return out;
    }
}

