/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl;

import javax.sql.DataSource;
import org.nutz.dao.Condition;
import org.nutz.dao.SqlManager;
import org.nutz.dao.entity.EntityMaker;
import org.nutz.dao.entity.LinkField;
import org.nutz.dao.entity.LinkVisitor;
import org.nutz.dao.impl.EntityOperator;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.impl.sql.pojo.ConditionPItem;
import org.nutz.dao.sql.Criteria;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.PItem;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.util.Pojos;
import org.nutz.dao.util.cri.SqlExpressionGroup;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class NutDaoExt
extends NutDao {
    private static final Log log = Logs.get();

    public NutDaoExt() {
    }

    public NutDaoExt(DataSource dataSource) {
        super(dataSource);
        this._warn();
    }

    public NutDaoExt(DataSource dataSource, SqlManager sqlManager) {
        super(dataSource, sqlManager);
        this._warn();
    }

    public NutDaoExt(DataSource dataSource, EntityMaker maker) {
        super(dataSource, maker);
        this._warn();
    }

    protected void _warn() {
        log.info((Object)"This is patched version NutDao for using daocache at 1.b.52 or lower. This patch was applied in 1.b.53");
    }

    public <T> T fetchLinks(T obj, final String regex, final Condition cnd) {
        if (null == obj) {
            return null;
        }
        Lang.each(obj, (boolean)false, (Each)new Each<Object>(){

            public void invoke(int index, Object ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                EntityOperator opt = NutDaoExt.this._optBy(ele);
                if (null == opt) {
                    return;
                }
                opt.entity.visitMany(ele, regex, NutDaoExt.this.doLinkQuery(opt, cnd));
                opt.entity.visitManyMany(ele, regex, NutDaoExt.this.doLinkQuery(opt, cnd));
                opt.entity.visitOne(ele, regex, NutDaoExt.this.doFetch(opt));
                opt.exec();
            }
        });
        return obj;
    }

    protected LinkVisitor doFetch(final EntityOperator opt) {
        return new LinkVisitor(){

            public void visit(Object obj, LinkField lnk) {
                Pojo pojo = opt.maker().makeQuery(lnk.getLinkedEntity());
                pojo.setOperatingObject(obj);
                pojo.append(Pojos.Items.cnd((Condition)lnk.createCondition(obj)));
                pojo.setAfter(lnk.getCallback());
                NutDaoExt.this._exec(new DaoStatement[]{pojo});
                lnk.setValue(obj, pojo.getObject(Object.class));
            }
        };
    }

    protected LinkVisitor doLinkQuery(final EntityOperator opt, final Condition cnd) {
        return new LinkVisitor(){

            public void visit(Object obj, LinkField lnk) {
                Pojo pojo = opt.maker().makeQuery(lnk.getLinkedEntity());
                pojo.setOperatingObject(obj);
                PItem[] _cndItems = Pojos.Items.cnd((Condition)lnk.createCondition(obj));
                pojo.append(_cndItems);
                if (cnd != null) {
                    if (cnd instanceof Criteria) {
                        Criteria cri = (Criteria)cnd;
                        SqlExpressionGroup seg = cri.where();
                        if (_cndItems.length > 0 && seg != null && !seg.isEmpty()) {
                            seg.setTop(false);
                            pojo.append(new PItem[]{Pojos.Items.wrap((String)" AND ")});
                        }
                        pojo.append(new PItem[]{cri});
                        if (cri.getPager() != null) {
                            pojo.setPager(cri.getPager());
                            NutDaoExt.this.expert.formatQuery((DaoStatement)pojo);
                        }
                    } else {
                        pojo.append(new PItem[]{new ConditionPItem(cnd)});
                    }
                }
                pojo.setAfter(lnk.getCallback());
                pojo.setEntity(lnk.getLinkedEntity());
                NutDaoExt.this._exec(new DaoStatement[]{pojo});
                lnk.setValue(obj, pojo.getResult());
            }
        };
    }
}

