/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.clusterhealthy;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opengauss.clusterhealthy.ClusterHeartBeat;
import org.opengauss.clusterhealthy.FailureCluster;
import org.opengauss.core.QueryExecutor;
import org.opengauss.log.Log;
import org.opengauss.log.Logger;
import org.opengauss.util.HostSpec;

public class ClusterHeartBeatFailureCluster
extends ClusterHeartBeat {
    public List<FailureCluster> failureCluster = new ArrayList<FailureCluster>();
    private int thresholdValue;
    private static volatile ClusterHeartBeatFailureCluster clusterHeartBeatFailureCluster;
    private static Log LOGGER;

    private ClusterHeartBeatFailureCluster() {
    }

    public static synchronized ClusterHeartBeatFailureCluster getInstance() {
        if (clusterHeartBeatFailureCluster == null) {
            clusterHeartBeatFailureCluster = new ClusterHeartBeatFailureCluster();
        }
        return clusterHeartBeatFailureCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.failureCluster.isEmpty()) {
            return;
        }
        ArrayList<FailureCluster> list = new ArrayList<FailureCluster>(this.failureCluster);
        this.failureCluster.clear();
        LOGGER.debug("cluster does not have a master node" + list);
        for (FailureCluster cluster : list) {
            QueryExecutor queryExecutor;
            block11: {
                queryExecutor = null;
                try {
                    if (cluster == null || cluster.getMaster() == null) continue;
                    queryExecutor = this.getQueryExecutor(cluster.getMaster(), cluster.getProps());
                }
                catch (SQLException e) {
                    Set<HostSpec> salves = cluster.getSalves();
                    int count = 0;
                    for (HostSpec salf : salves) {
                        QueryExecutor salveQueryExcutor = null;
                        try {
                            salveQueryExcutor = this.getQueryExecutor(salf, cluster.getProps());
                        }
                        catch (SQLException ex) {
                            ++count;
                        }
                        finally {
                            if (salveQueryExcutor == null) continue;
                            salveQueryExcutor.close();
                        }
                    }
                    if (count == salves.size()) continue;
                    int frequency = cluster.getFrequency();
                    if (this.thresholdValue <= frequency) break block11;
                    this.cacheProcess(cluster.getMaster(), salves, cluster.getProps(), ++frequency);
                }
            }
            if (queryExecutor == null) continue;
            boolean isMaster = this.nodeRoleIsMaster(queryExecutor);
            if (isMaster) {
                this.addClusterNode(cluster.getMaster(), cluster.getSalves().toArray(new HostSpec[0]));
                this.addProperties(cluster.getMaster(), cluster.getProps());
                continue;
            }
            HostSpec maseterNode = this.findMasterNode(cluster.getSalves(), cluster.getProps());
            if (maseterNode == null) continue;
            this.addProperties(maseterNode, cluster.getProps());
            Set<HostSpec> salves = cluster.getSalves();
            salves.add(cluster.getMaster());
            this.removeClusterNode(cluster.getMaster(), maseterNode, salves);
        }
    }

    public void addFailureCluster(FailureCluster cluster) {
        this.failureCluster.add(cluster);
    }

    public List<FailureCluster> getFailureCluster() {
        return this.failureCluster;
    }

    @Override
    public void clear() {
        this.failureCluster.clear();
    }

    public void setThresholdValue(int thresholdValue) {
        this.thresholdValue = thresholdValue;
    }

    static {
        LOGGER = Logger.getLogger(ClusterHeartBeatFailureCluster.class.getName());
    }
}

