/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.jdbc;

import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.opengauss.jdbc.PgResultSet;
import org.opengauss.log.Log;
import org.opengauss.log.Logger;
import org.opengauss.util.GT;
import org.opengauss.util.PSQLException;
import org.opengauss.util.PSQLState;

class BooleanTypeUtil {
    private static Log LOGGER = Logger.getLogger(BooleanTypeUtil.class.getName());
    private static final Set<String> TRUE_SETS = Arrays.stream(new String[]{"1", "true", "t", "yes", "y", "on"}).collect(Collectors.toSet());
    private static final Set<String> FALSE_SETS = Arrays.stream(new String[]{"0", "false", "f", "no", "n", "off"}).collect(Collectors.toSet());
    public static final int MAX_SIGNED_LONG_LEN = 20;
    public static final BigInteger BIG_INTEGER_ZERO = BigInteger.valueOf(0L);
    public static final BigInteger BIG_INTEGER_NEGATIVE_ONE = BigInteger.valueOf(-1L);

    private BooleanTypeUtil() {
    }

    static boolean castToBoolean(Object in) throws SQLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cast to boolean: \"" + String.valueOf(in) + "\"");
        }
        if (in instanceof Boolean) {
            return (Boolean)in;
        }
        if (in instanceof String) {
            return BooleanTypeUtil.fromString((String)in);
        }
        if (in instanceof Character) {
            return BooleanTypeUtil.fromCharacter((Character)in);
        }
        if (in instanceof Number) {
            return BooleanTypeUtil.fromNumber((Number)in);
        }
        throw new PSQLException("Cannot cast to boolean", PSQLState.CANNOT_COERCE);
    }

    private static boolean fromString(String strval) throws SQLException {
        if ((strval = strval.trim()).isEmpty()) {
            return false;
        }
        byte[] newBytes = strval.getBytes();
        if (strval.equalsIgnoreCase("Y") || strval.equalsIgnoreCase("yes") || strval.equalsIgnoreCase("T") || strval.equalsIgnoreCase("true")) {
            return true;
        }
        if (strval.equalsIgnoreCase("N") || strval.equalsIgnoreCase("no") || strval.equalsIgnoreCase("F") || strval.equalsIgnoreCase("false")) {
            return false;
        }
        if (strval.contains("e") || strval.contains("E") || strval.matches("-?\\d*\\.\\d*")) {
            double d = Double.parseDouble(strval);
            return d > 0.0 || d == -1.0;
        }
        if (strval.matches("-?\\d+")) {
            if (strval.charAt(0) == '-' || strval.length() < 20 && newBytes[0] >= 48 && newBytes[0] <= 56) {
                long l = PgResultSet.toLong(strval);
                return l == -1L || l > 0L;
            }
            BigInteger bi = new BigInteger(strval);
            return bi.compareTo(BIG_INTEGER_ZERO) > 0 || bi.compareTo(BIG_INTEGER_NEGATIVE_ONE) == 0;
        }
        throw BooleanTypeUtil.cannotCoerceException(strval);
    }

    private static boolean isTrueStr(String strval) {
        return TRUE_SETS.contains(strval.toLowerCase());
    }

    private static boolean isFalseStr(String strval) {
        return FALSE_SETS.contains(strval.toLowerCase());
    }

    private static boolean fromCharacter(Character charval) throws PSQLException {
        if ('1' == charval.charValue() || 't' == charval.charValue() || 'T' == charval.charValue() || 'y' == charval.charValue() || 'Y' == charval.charValue()) {
            return true;
        }
        if ('0' == charval.charValue() || 'f' == charval.charValue() || 'F' == charval.charValue() || 'n' == charval.charValue() || 'N' == charval.charValue()) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException(charval);
    }

    private static boolean fromNumber(Number numval) throws PSQLException {
        double value = numval.doubleValue();
        if (value == 1.0) {
            return true;
        }
        if (value == 0.0) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException(numval);
    }

    private static PSQLException cannotCoerceException(Object value) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cannot cast to boolean: \"" + String.valueOf(value) + "\"");
        }
        return new PSQLException(GT.tr("Cannot cast to boolean: \"{0}\"", String.valueOf(value)), PSQLState.CANNOT_COERCE);
    }
}

