/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.callback.CallbackHandler;
import org.openeuler.BGMProvider;
import org.opengauss.PGProperty;
import org.opengauss.jdbc.SslMode;
import org.opengauss.log.Log;
import org.opengauss.log.Logger;
import org.opengauss.ssl.LazyKeyManager;
import org.opengauss.ssl.LibPQFactory;
import org.opengauss.ssl.NonValidatingFactory;
import org.opengauss.ssl.WrappedFactory;
import org.opengauss.util.GT;
import org.opengauss.util.ObjectFactory;
import org.opengauss.util.PSQLException;
import org.opengauss.util.PSQLState;

public class LibPQTlcpFactory
extends WrappedFactory {
    LazyKeyManager signKm;
    LazyKeyManager encKm;
    private static Log LOGGER = Logger.getLogger(LibPQTlcpFactory.class.getName());

    public LibPQTlcpFactory(Properties info) throws PSQLException {
        try {
            CallbackHandler cbh;
            String tlcpEncKeyFile;
            String tlcpKeyFile;
            String tlcpEncCertFile;
            String tlcpCertFile;
            TrustManager[] tm = null;
            KeyManager[] keyManagers = null;
            SslMode sslMode = SslMode.of(info);
            Security.insertProviderAt((Provider)new BGMProvider(), 1);
            SSLContext ctx = SSLContext.getInstance("GMTLS");
            String pathsep = System.getProperty("file.separator");
            boolean defaultSignFile = false;
            boolean defaultEncFile = false;
            String defaultDir = System.getProperty("os.name").toLowerCase().contains("windows") ? System.getenv("APPDATA") + pathsep + "postgresql" + pathsep : System.getProperty("user.home") + pathsep + ".postgresql" + pathsep;
            String tlcpRootCertFile = PGProperty.SSL_ROOT_CERT.get(info);
            if (tlcpRootCertFile == null) {
                tlcpRootCertFile = defaultDir + "root.crt";
            }
            if ((tlcpCertFile = PGProperty.SSL_CERT.get(info)) == null) {
                defaultSignFile = true;
                tlcpCertFile = defaultDir + "postgresql.crt";
            }
            if ((tlcpEncCertFile = PGProperty.SSL_ENC_CERT.get(info)) == null) {
                defaultEncFile = true;
                tlcpEncCertFile = defaultDir + "postgresql_enc.crt";
            }
            if ((tlcpKeyFile = PGProperty.SSL_KEY.get(info)) == null) {
                defaultSignFile = true;
                tlcpKeyFile = defaultDir + "postgresql.pk8";
            }
            if ((tlcpEncKeyFile = PGProperty.SSL_ENC_KEY.get(info)) == null) {
                defaultEncFile = true;
                tlcpEncKeyFile = defaultDir + "postgresql_enc.pk8";
            }
            if (!sslMode.verifyCertificate()) {
                tm = new TrustManager[]{new NonValidatingFactory.NonValidatingTM()};
            } else {
                FileInputStream fis;
                KeyStore ks;
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
                try {
                    ks = KeyStore.getInstance("jks");
                }
                catch (KeyStoreException e) {
                    throw new NoSuchAlgorithmException("jks KeyStore not available");
                }
                try {
                    fis = new FileInputStream(tlcpRootCertFile);
                }
                catch (FileNotFoundException ex) {
                    throw new PSQLException(GT.tr("Could not open SSL root certificate file {0}.", tlcpRootCertFile), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
                }
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    Certificate[] certs = cf.generateCertificates(fis).toArray(new Certificate[0]);
                    ks.load(null, null);
                    for (int i = 0; i < certs.length; ++i) {
                        ks.setCertificateEntry("cert" + i, certs[i]);
                    }
                    tmf.init(ks);
                }
                catch (IOException ioex) {
                    throw new PSQLException(GT.tr("Could not read SSL root certificate file {0}.", tlcpRootCertFile), PSQLState.CONNECTION_FAILURE, (Throwable)ioex);
                }
                catch (GeneralSecurityException gsex) {
                    throw new PSQLException(GT.tr("Loading the SSL root certificate {0} into a TrustManager failed.", tlcpRootCertFile), PSQLState.CONNECTION_FAILURE, (Throwable)gsex);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        LOGGER.trace("Catch IOException on close:", e);
                    }
                }
                tm = tmf.getTrustManagers();
            }
            String sslPasswordCallback = PGProperty.SSL_PASSWORD_CALLBACK.get(info);
            if (sslPasswordCallback != null) {
                try {
                    cbh = ObjectFactory.instantiate(CallbackHandler.class, sslPasswordCallback, info, false, null);
                }
                catch (Exception e) {
                    throw new PSQLException(GT.tr("The password callback class provided {0} could not be instantiated.", sslPasswordCallback), PSQLState.CONNECTION_FAILURE, (Throwable)e);
                }
            } else {
                cbh = new LibPQFactory.ConsoleCallbackHandler(PGProperty.SSL_PASSWORD.get(info));
            }
            this.signKm = new LazyKeyManager("".equals(tlcpCertFile) ? null : tlcpCertFile, "".equals(tlcpKeyFile) ? null : tlcpKeyFile, cbh, defaultSignFile, PGProperty.SSL_PRIVATEKEY_FACTORY.get(info));
            this.encKm = new LazyKeyManager("".equals(tlcpEncCertFile) ? null : tlcpEncCertFile, "".equals(tlcpEncKeyFile) ? null : tlcpEncKeyFile, cbh, defaultEncFile, PGProperty.SSL_PRIVATEKEY_FACTORY.get(info));
            try {
                PrivateKey signKey = this.signKm.getPrivateKey("signKey");
                PrivateKey encKey = this.encKm.getPrivateKey("encKey");
                if (signKey != null && encKey != null) {
                    KeyStore ks = KeyStore.getInstance("PKCS12");
                    ks.load(null);
                    ks.setKeyEntry("sign", signKey, null, this.signKm.getCertificateChain("signCert"));
                    ks.setKeyEntry("enc", encKey, null, this.encKm.getCertificateChain("encCert"));
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(ks, null);
                    keyManagers = kmf.getKeyManagers();
                } else {
                    this.throwKeyManagerException();
                }
            }
            catch (CertificateException ex) {
                throw new PSQLException(GT.tr("Failed to verify tlcp certificates during the keystore loading phase: {0}.", ex.getMessage()), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
            }
            catch (UnrecoverableKeyException ex) {
                throw new PSQLException(GT.tr("Could not recover key during the keystore initialization phase: {0}.", ex.getMessage()), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
            }
            catch (IOException ex) {
                throw new PSQLException(GT.tr("Some io errors occur during the keystore loading phase: {0}.", ex.getMessage()), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
            }
            catch (KeyStoreException ex) {
                throw new PSQLException(GT.tr("Could not finish keystore processing: {0}.", ex.getMessage()), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
            }
            try {
                ctx.init(keyManagers, tm, null);
            }
            catch (KeyManagementException ex) {
                throw new PSQLException(GT.tr("Could not initialize SSL context.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
            }
            this._factory = ctx.getSocketFactory();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new PSQLException(GT.tr("Could not find a java cryptographic algorithm: {0}.", ex.getMessage()), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    public void throwKeyManagerException() throws PSQLException {
        if (this.signKm != null) {
            this.signKm.throwKeyManagerException();
        }
        if (this.encKm != null) {
            this.encKm.throwKeyManagerException();
        }
    }
}

