/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.api.createSession;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.message.AbstractExtendedRequest;
import org.openldap.accelerator.api.createSession.RbacCreateSessionRequest;
import org.openldap.accelerator.api.createSession.RbacCreateSessionResponse;
import org.openldap.accelerator.api.createSession.RbacCreateSessionResponseImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacCreateSessionRequestImpl
extends AbstractExtendedRequest
implements RbacCreateSessionRequest {
    private String sessionId;
    private String tenantId;
    private String userIdentity;
    private String password;
    private List<String> roles;

    public RbacCreateSessionRequestImpl() {
        this.setRequestName("1.3.6.1.4.1.4203.555.1");
    }

    public RbacCreateSessionRequestImpl(int messageId) {
        super(messageId);
        this.setRequestName("1.3.6.1.4.1.4203.555.1");
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantID) {
        this.tenantId = tenantID;
    }

    @Override
    public void setSessionId(String sessionID) {
        this.sessionId = sessionID;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getUserIdentity() {
        return this.userIdentity;
    }

    @Override
    public void setUserIdentity(String userIdentity) {
        this.userIdentity = userIdentity;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public List<String> getRoles() {
        return this.roles;
    }

    @Override
    public void setRoles(List<String> roles) {
        if (roles != null) {
            this.roles = new ArrayList<String>(roles.size());
            this.roles.addAll(roles);
        }
    }

    @Override
    public void addRole(String role) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(role);
    }

    public RbacCreateSessionResponse getResultResponse() {
        if (this.getResponse() == null) {
            this.setResponse(new RbacCreateSessionResponseImpl());
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RbacCreateSessionRequest :");
        if (this.sessionId != null) {
            sb.append("\n    sessionId : ").append(this.sessionId);
        }
        if (this.tenantId != null) {
            sb.append("\n    tenantId : ").append(this.tenantId);
        }
        if (this.userIdentity != null) {
            sb.append("\n    userIdentity : ").append(this.userIdentity);
        }
        if (this.password != null) {
            sb.append("\n    password : ").append(this.password);
        }
        if (this.roles != null) {
            sb.append("\n    roles : {");
            if (this.roles.size() != 0) {
                boolean isFirst = true;
                for (String role : this.roles) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(role);
                }
            }
            sb.append("}");
        }
        return sb.toString();
    }
}

