/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.api.sessionRoles;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.openldap.accelerator.api.sessionRoles.RbacSessionRolesResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacSessionRolesResponseImpl
extends ExtendedResponseImpl
implements RbacSessionRolesResponse {
    private List<String> roles;

    public RbacSessionRolesResponseImpl(int messageId, ResultCodeEnum rcode, String diagnosticMessage) {
        super(messageId, "1.3.6.1.4.1.4203.555.6");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
        super.getLdapResult().setDiagnosticMessage(diagnosticMessage);
    }

    public RbacSessionRolesResponseImpl(int messageId, ResultCodeEnum rcode) {
        super(messageId, "1.3.6.1.4.1.4203.555.6");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public RbacSessionRolesResponseImpl(int messageId) {
        super(messageId, "1.3.6.1.4.1.4203.555.6");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    public RbacSessionRolesResponseImpl() {
        super("1.3.6.1.4.1.4203.555.6");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    @Override
    public List<String> getRoles() {
        return this.roles;
    }

    @Override
    public void setRoles(List<String> roles) {
        if (roles != null) {
            this.roles = new ArrayList<String>(roles.size());
            this.roles.addAll(roles);
        }
    }

    @Override
    public void addRole(String role) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(role);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RbacSessionRoles response :");
        if (this.roles != null) {
            sb.append("\n    roles : {");
            if (this.roles.size() != 0) {
                boolean isFirst = true;
                for (String role : this.roles) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(role);
                }
            }
            sb.append("}");
        }
        return sb.toString();
    }
}

