/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.checkAccess;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.util.Strings;
import org.openldap.accelerator.api.checkAccess.RbacCheckAccessRequest;
import org.openldap.accelerator.api.checkAccess.RbacCheckAccessRequestImpl;
import org.openldap.accelerator.impl.checkAccess.RbacCheckAccessRequestContainer;
import org.openldap.accelerator.impl.checkAccess.RbacCheckAccessRequestDecorator;
import org.openldap.accelerator.impl.checkAccess.RbacCheckAccessRequestStatesEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacCheckAccessRequestGrammar
extends AbstractGrammar<RbacCheckAccessRequestContainer> {
    static final Logger LOG = LoggerFactory.getLogger(RbacCheckAccessRequestGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<RbacCheckAccessRequestContainer> instance = new RbacCheckAccessRequestGrammar();

    private RbacCheckAccessRequestGrammar() {
        this.setName(RbacCheckAccessRequestGrammar.class.getName());
        this.transitions = new GrammarTransition[RbacCheckAccessRequestStatesEnum.LAST_RBAC_CHECK_ACCESS_REQ_STATE.ordinal()][256];
        this.transitions[RbacCheckAccessRequestStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)RbacCheckAccessRequestStatesEnum.START_STATE, (Enum)RbacCheckAccessRequestStatesEnum.RBAC_CHECK_ACCESS_REQ_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<RbacCheckAccessRequestContainer>("Init RbacCheckAccessRequest"){

            public void action(RbacCheckAccessRequestContainer rbacCheckAccessContainer) {
                RbacCheckAccessRequestDecorator rbacCheckAccessRequestDecorator = new RbacCheckAccessRequestDecorator(LdapApiServiceFactory.getSingleton(), (RbacCheckAccessRequest)new RbacCheckAccessRequestImpl());
                rbacCheckAccessContainer.setRbacCheckAccessRequest(rbacCheckAccessRequestDecorator);
            }
        });
        this.transitions[RbacCheckAccessRequestStatesEnum.RBAC_CHECK_ACCESS_REQ_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition((Enum)RbacCheckAccessRequestStatesEnum.RBAC_CHECK_ACCESS_REQ_SEQUENCE_STATE, (Enum)RbacCheckAccessRequestStatesEnum.RBAC_CHECK_ACCESS_REQ_SESSION_ID_STATE, 128, (Action)new GrammarAction<RbacCheckAccessRequestContainer>("Stores sessionId"){

            public void action(RbacCheckAccessRequestContainer rbacCheckAccessContainer) throws DecoderException {
                BerValue value = rbacCheckAccessContainer.getCurrentTLV().getValue();
                String sessionId = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("sessionId = {}", (Object)sessionId);
                }
                rbacCheckAccessContainer.getRbacCheckAccessRequest().setSessionId(sessionId);
            }
        });
        this.transitions[RbacCheckAccessRequestStatesEnum.RBAC_CHECK_ACCESS_REQ_SESSION_ID_STATE.ordinal()][129] = new GrammarTransition((Enum)RbacCheckAccessRequestStatesEnum.RBAC_CHECK_ACCESS_REQ_SESSION_ID_STATE, (Enum)RbacCheckAccessRequestStatesEnum.RBAC_CHECK_ACCESS_REQ_OPERATION_STATE, 129, (Action)new GrammarAction<RbacCheckAccessRequestContainer>("Stores operation"){

            public void action(RbacCheckAccessRequestContainer rbacCheckAccessContainer) throws DecoderException {
                BerValue value = rbacCheckAccessContainer.getCurrentTLV().getValue();
                String operation = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("operation = " + operation);
                }
                System.out.println("set operation: " + operation);
                rbacCheckAccessContainer.getRbacCheckAccessRequest().setOperation(operation);
            }
        });
        this.transitions[RbacCheckAccessRequestStatesEnum.RBAC_CHECK_ACCESS_REQ_OPERATION_STATE.ordinal()][130] = new GrammarTransition((Enum)RbacCheckAccessRequestStatesEnum.RBAC_CHECK_ACCESS_REQ_OPERATION_STATE, (Enum)RbacCheckAccessRequestStatesEnum.RBAC_CHECK_ACCESS_REQ_OBJECT_STATE, 130, (Action)new GrammarAction<RbacCheckAccessRequestContainer>("Stores object"){

            public void action(RbacCheckAccessRequestContainer rbacCheckAccessContainer) throws DecoderException {
                BerValue value = rbacCheckAccessContainer.getCurrentTLV().getValue();
                String object = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("object = " + object);
                }
                rbacCheckAccessContainer.getRbacCheckAccessRequest().setObject(object);
                System.out.println("set object: " + object);
                rbacCheckAccessContainer.setGrammarEndAllowed(true);
            }
        });
        this.transitions[RbacCheckAccessRequestStatesEnum.RBAC_CHECK_ACCESS_REQ_OBJECT_STATE.ordinal()][131] = new GrammarTransition((Enum)RbacCheckAccessRequestStatesEnum.RBAC_CHECK_ACCESS_REQ_OBJECT_STATE, (Enum)RbacCheckAccessRequestStatesEnum.RBAC_CHECK_ACCESS_REQ_OBJECTID_STATE, 131, (Action)new GrammarAction<RbacCheckAccessRequestContainer>("Stores objectId"){

            public void action(RbacCheckAccessRequestContainer rbacCheckAccessContainer) throws DecoderException {
                BerValue value = rbacCheckAccessContainer.getCurrentTLV().getValue();
                String objectId = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("objectId = " + objectId);
                }
                rbacCheckAccessContainer.getRbacCheckAccessRequest().setObjectId(objectId);
                System.out.println("set objectId: " + objectId);
                rbacCheckAccessContainer.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<RbacCheckAccessRequestContainer> getInstance() {
        return instance;
    }
}

