/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.checkAccess;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.util.Strings;
import org.openldap.accelerator.api.checkAccess.RbacCheckAccessResponse;
import org.openldap.accelerator.api.checkAccess.RbacCheckAccessResponseImpl;
import org.openldap.accelerator.impl.checkAccess.RbacCheckAccessResponseContainer;
import org.openldap.accelerator.impl.checkAccess.RbacCheckAccessResponseDecorator;
import org.openldap.accelerator.impl.checkAccess.RbacCheckAccessResponseStatesEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacCheckAccessResponseGrammar
extends AbstractGrammar<RbacCheckAccessResponseContainer> {
    static final Logger LOG = LoggerFactory.getLogger(RbacCheckAccessResponseGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<RbacCheckAccessResponseContainer> instance = new RbacCheckAccessResponseGrammar();

    private RbacCheckAccessResponseGrammar() {
        this.setName(RbacCheckAccessResponseGrammar.class.getName());
        this.transitions = new GrammarTransition[RbacCheckAccessResponseStatesEnum.LAST_RBAC_CHECK_ACCESS_RESP_STATE.ordinal()][256];
        this.transitions[RbacCheckAccessResponseStatesEnum.START_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)RbacCheckAccessResponseStatesEnum.START_STATE, (Enum)RbacCheckAccessResponseStatesEnum.RBAC_CHECK_ACCESS_RESP_GRANTED_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<RbacCheckAccessResponseContainer>("Init RbacCheckAccessResponse, set the granted flag"){

            public void action(RbacCheckAccessResponseContainer rbacCheckAccessContainer) throws DecoderException {
                RbacCheckAccessResponseDecorator rbacCheckAccessResponseDecorator = new RbacCheckAccessResponseDecorator(LdapApiServiceFactory.getSingleton(), (RbacCheckAccessResponse)new RbacCheckAccessResponseImpl());
                rbacCheckAccessContainer.setRbacCheckAccessResponse(rbacCheckAccessResponseDecorator);
                BerValue value = rbacCheckAccessContainer.getCurrentTLV().getValue();
                try {
                    rbacCheckAccessResponseDecorator.setGranted(BooleanDecoder.parse((BerValue)value));
                }
                catch (BooleanDecoderException bde) {
                    LOG.error("Cannot decode the Granted flag : {}", (Object)Strings.dumpBytes((byte[])value.getData()));
                    throw new DecoderException(bde.getMessage());
                }
                rbacCheckAccessContainer.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<RbacCheckAccessResponseContainer> getInstance() {
        return instance;
    }
}

