/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.createSession;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.util.Strings;
import org.openldap.accelerator.api.createSession.RbacCreateSessionResponse;
import org.openldap.accelerator.api.createSession.RbacCreateSessionResponseImpl;
import org.openldap.accelerator.impl.createSession.RbacCreateSessionResponseContainer;
import org.openldap.accelerator.impl.createSession.RbacCreateSessionResponseDecorator;
import org.openldap.accelerator.impl.createSession.RbacCreateSessionResponseStatesEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacCreateSessionResponseGrammar
extends AbstractGrammar<RbacCreateSessionResponseContainer> {
    static final Logger LOG = LoggerFactory.getLogger(RbacCreateSessionResponseGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<RbacCreateSessionResponseContainer> instance = new RbacCreateSessionResponseGrammar();

    private RbacCreateSessionResponseGrammar() {
        this.setName(RbacCreateSessionResponseGrammar.class.getName());
        this.transitions = new GrammarTransition[RbacCreateSessionResponseStatesEnum.LAST_RBAC_CREATE_SESSION_RESP_STATE.ordinal()][256];
        this.transitions[RbacCreateSessionResponseStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)RbacCreateSessionResponseStatesEnum.START_STATE, (Enum)RbacCreateSessionResponseStatesEnum.RBAC_CREATE_SESSION_RESP_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<RbacCreateSessionResponseContainer>("Init RbacCreateSessionResponse"){

            public void action(RbacCreateSessionResponseContainer rbacCreateSessionContainer) {
                RbacCreateSessionResponseDecorator rbacCreateSessionResponseDecorator = new RbacCreateSessionResponseDecorator(LdapApiServiceFactory.getSingleton(), (RbacCreateSessionResponse)new RbacCreateSessionResponseImpl());
                rbacCreateSessionContainer.setRbacCreateSessionResponse(rbacCreateSessionResponseDecorator);
            }
        });
        this.transitions[RbacCreateSessionResponseStatesEnum.RBAC_CREATE_SESSION_RESP_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition((Enum)RbacCreateSessionResponseStatesEnum.RBAC_CREATE_SESSION_RESP_SEQUENCE_STATE, (Enum)RbacCreateSessionResponseStatesEnum.RBAC_CREATE_SESSION_RESP_SESSION_ID_STATE, 128, (Action)new GrammarAction<RbacCreateSessionResponseContainer>("Stores sessionID"){

            public void action(RbacCreateSessionResponseContainer rbacCreateSessionContainer) throws DecoderException {
                BerValue value = rbacCreateSessionContainer.getCurrentTLV().getValue();
                String sessionID = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("sessionID = {}", (Object)sessionID);
                }
                rbacCreateSessionContainer.getRbacCreateSessionResponse().setSessionId(sessionID);
                rbacCreateSessionContainer.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<RbacCreateSessionResponseContainer> getInstance() {
        return instance;
    }
}

