/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.deleteSession;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.util.Strings;
import org.openldap.accelerator.api.deleteSession.RbacDeleteSessionRequest;
import org.openldap.accelerator.impl.deleteSession.RbacDeleteSessionRequestDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacDeleteSessionRequestDecorator
extends ExtendedRequestDecorator<RbacDeleteSessionRequest>
implements RbacDeleteSessionRequest {
    private static final Logger LOG = LoggerFactory.getLogger(RbacDeleteSessionRequestDecorator.class);
    private RbacDeleteSessionRequest rbacDeleteSessionRequest;
    private int requestLength = 0;
    private byte[] sessionIdBytes;
    private byte[] userIdentityBytes;

    public RbacDeleteSessionRequestDecorator(LdapApiService codec, RbacDeleteSessionRequest decoratedMessage) {
        super(codec, (ExtendedRequest)decoratedMessage);
        this.rbacDeleteSessionRequest = decoratedMessage;
    }

    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                this.requestValue = this.encodeInternal().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04167, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.requestValue;
    }

    public void setRequestValue(byte[] requestValue) {
        RbacDeleteSessionRequestDecoder decoder = new RbacDeleteSessionRequestDecoder();
        try {
            this.rbacDeleteSessionRequest = decoder.decode(requestValue);
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04165, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setSessionId(String sessionID) {
        this.rbacDeleteSessionRequest.setSessionId(sessionID);
    }

    public String getSessionId() {
        return this.rbacDeleteSessionRequest.getSessionId();
    }

    public String getUserIdentity() {
        return this.rbacDeleteSessionRequest.getUserIdentity();
    }

    public void setUserIdentity(String userIdentity) {
        this.rbacDeleteSessionRequest.setUserIdentity(userIdentity);
    }

    int computeLengthInternal() {
        int len;
        this.requestLength = 0;
        if (this.rbacDeleteSessionRequest.getUserIdentity() != null) {
            this.userIdentityBytes = Strings.getBytesUtf8((String)this.rbacDeleteSessionRequest.getUserIdentity());
            len = this.userIdentityBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        } else {
            this.requestLength += 2;
        }
        if (this.rbacDeleteSessionRequest.getSessionId() != null) {
            this.sessionIdBytes = Strings.getBytesUtf8((String)this.rbacDeleteSessionRequest.getSessionId());
            len = this.sessionIdBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        } else {
            this.requestLength += 2;
        }
        return 1 + TLV.getNbBytes((int)this.requestLength) + this.requestLength;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes((int)this.requestLength));
        if (this.rbacDeleteSessionRequest.getUserIdentity() != null) {
            bb.put((byte)-128);
            bb.put(TLV.getBytes((int)this.userIdentityBytes.length));
            bb.put(this.userIdentityBytes);
        }
        if (this.rbacDeleteSessionRequest.getSessionId() != null) {
            bb.put((byte)-127);
            bb.put(TLV.getBytes((int)this.sessionIdBytes.length));
            bb.put(this.sessionIdBytes);
        }
        return bb;
    }

    public String toString() {
        return this.rbacDeleteSessionRequest.toString();
    }
}

