/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.deleteSession;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.util.Strings;
import org.openldap.accelerator.api.deleteSession.RbacDeleteSessionRequest;
import org.openldap.accelerator.api.deleteSession.RbacDeleteSessionRequestImpl;
import org.openldap.accelerator.impl.deleteSession.RbacDeleteSessionRequestContainer;
import org.openldap.accelerator.impl.deleteSession.RbacDeleteSessionRequestDecorator;
import org.openldap.accelerator.impl.deleteSession.RbacDeleteSessionRequestStatesEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacDeleteSessionRequestGrammar
extends AbstractGrammar<RbacDeleteSessionRequestContainer> {
    static final Logger LOG = LoggerFactory.getLogger(RbacDeleteSessionRequestGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<RbacDeleteSessionRequestContainer> instance = new RbacDeleteSessionRequestGrammar();

    private RbacDeleteSessionRequestGrammar() {
        this.setName(RbacDeleteSessionRequestGrammar.class.getName());
        this.transitions = new GrammarTransition[RbacDeleteSessionRequestStatesEnum.LAST_RBAC_DELETE_SESSION_REQ_STATE.ordinal()][256];
        this.transitions[RbacDeleteSessionRequestStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)RbacDeleteSessionRequestStatesEnum.START_STATE, (Enum)RbacDeleteSessionRequestStatesEnum.RBAC_DELETE_SESSION_REQ_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<RbacDeleteSessionRequestContainer>("Init RbacDeleteSessionRequest"){

            public void action(RbacDeleteSessionRequestContainer rbacDeleteSessionContainer) {
                RbacDeleteSessionRequestDecorator rbacDeleteSessionRequestDecorator = new RbacDeleteSessionRequestDecorator(LdapApiServiceFactory.getSingleton(), (RbacDeleteSessionRequest)new RbacDeleteSessionRequestImpl());
                rbacDeleteSessionContainer.setRbacDeleteSessionRequest(rbacDeleteSessionRequestDecorator);
            }
        });
        this.transitions[RbacDeleteSessionRequestStatesEnum.RBAC_DELETE_SESSION_REQ_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition((Enum)RbacDeleteSessionRequestStatesEnum.RBAC_DELETE_SESSION_REQ_SEQUENCE_STATE, (Enum)RbacDeleteSessionRequestStatesEnum.RBAC_DELETE_SESSION_REQ_USER_IDENTITY_STATE, 128, (Action)new GrammarAction<RbacDeleteSessionRequestContainer>("Stores userIdentity"){

            public void action(RbacDeleteSessionRequestContainer rbacDeleteSessionContainer) throws DecoderException {
                BerValue value = rbacDeleteSessionContainer.getCurrentTLV().getValue();
                String userIdentity = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("userIdentity = {}", (Object)userIdentity);
                }
                rbacDeleteSessionContainer.getRbacDeleteSessionRequest().setUserIdentity(userIdentity);
            }
        });
        this.transitions[RbacDeleteSessionRequestStatesEnum.RBAC_DELETE_SESSION_REQ_USER_IDENTITY_STATE.ordinal()][129] = new GrammarTransition((Enum)RbacDeleteSessionRequestStatesEnum.RBAC_DELETE_SESSION_REQ_USER_IDENTITY_STATE, (Enum)RbacDeleteSessionRequestStatesEnum.RBAC_DELETE_SESSION_REQ_SESSION_ID_STATE, 129, (Action)new GrammarAction<RbacDeleteSessionRequestContainer>("Stores sessionId"){

            public void action(RbacDeleteSessionRequestContainer rbacDeleteSessionContainer) throws DecoderException {
                BerValue value = rbacDeleteSessionContainer.getCurrentTLV().getValue();
                String sessionId = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("sessionID = " + sessionId);
                }
                rbacDeleteSessionContainer.getRbacDeleteSessionRequest().setSessionId(sessionId);
                rbacDeleteSessionContainer.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<RbacDeleteSessionRequestContainer> getInstance() {
        return instance;
    }
}

