/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.dropRole;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.util.Strings;
import org.openldap.accelerator.api.dropRole.RbacDropRoleRequest;
import org.openldap.accelerator.impl.dropRole.RbacDropRoleRequestDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacDropRoleRequestDecorator
extends ExtendedRequestDecorator<RbacDropRoleRequest>
implements RbacDropRoleRequest {
    private static final Logger LOG = LoggerFactory.getLogger(RbacDropRoleRequestDecorator.class);
    private RbacDropRoleRequest rbacDropRoleRequest;
    private int requestLength = 0;
    private byte[] sessionIdBytes;
    private byte[] userIdentityBytes;
    private byte[] roleBytes;

    public RbacDropRoleRequestDecorator(LdapApiService codec, RbacDropRoleRequest decoratedMessage) {
        super(codec, (ExtendedRequest)decoratedMessage);
        this.rbacDropRoleRequest = decoratedMessage;
    }

    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                this.requestValue = this.encodeInternal().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04167, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.requestValue;
    }

    public void setRequestValue(byte[] requestValue) {
        RbacDropRoleRequestDecoder decoder = new RbacDropRoleRequestDecoder();
        try {
            this.rbacDropRoleRequest = decoder.decode(requestValue);
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04165, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setSessionId(String sessionID) {
        this.rbacDropRoleRequest.setSessionId(sessionID);
    }

    public String getSessionId() {
        return this.rbacDropRoleRequest.getSessionId();
    }

    public String getUserIdentity() {
        return this.rbacDropRoleRequest.getUserIdentity();
    }

    public void setUserIdentity(String userIdentity) {
        this.rbacDropRoleRequest.setUserIdentity(userIdentity);
    }

    public String getRole() {
        return this.rbacDropRoleRequest.getRole();
    }

    public void setRole(String role) {
        this.rbacDropRoleRequest.setRole(role);
    }

    int computeLengthInternal() {
        int len;
        this.requestLength = 0;
        if (this.rbacDropRoleRequest.getUserIdentity() != null) {
            this.userIdentityBytes = Strings.getBytesUtf8((String)this.rbacDropRoleRequest.getUserIdentity());
            len = this.userIdentityBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        } else {
            this.requestLength += 2;
        }
        if (this.rbacDropRoleRequest.getSessionId() != null) {
            this.sessionIdBytes = Strings.getBytesUtf8((String)this.rbacDropRoleRequest.getSessionId());
            len = this.sessionIdBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        } else {
            this.requestLength += 2;
        }
        if (this.rbacDropRoleRequest.getRole() != null) {
            this.roleBytes = Strings.getBytesUtf8((String)this.rbacDropRoleRequest.getRole());
            len = this.roleBytes.length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        } else {
            this.requestLength += 2;
        }
        return 1 + TLV.getNbBytes((int)this.requestLength) + this.requestLength;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes((int)this.requestLength));
        if (this.rbacDropRoleRequest.getUserIdentity() != null) {
            bb.put((byte)-128);
            bb.put(TLV.getBytes((int)this.userIdentityBytes.length));
            bb.put(this.userIdentityBytes);
        }
        if (this.rbacDropRoleRequest.getSessionId() != null) {
            bb.put((byte)-127);
            bb.put(TLV.getBytes((int)this.sessionIdBytes.length));
            bb.put(this.sessionIdBytes);
        }
        if (this.rbacDropRoleRequest.getRole() != null) {
            bb.put((byte)-126);
            bb.put(TLV.getBytes((int)this.roleBytes.length));
            bb.put(this.roleBytes);
        }
        return bb;
    }

    public String toString() {
        return this.rbacDropRoleRequest.toString();
    }
}

