/*
 * Decompiled with CFR 0.152.
 */
package org.openldap.accelerator.impl.sessionRoles;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.util.Strings;
import org.openldap.accelerator.api.sessionRoles.RbacSessionRolesRequest;
import org.openldap.accelerator.api.sessionRoles.RbacSessionRolesRequestImpl;
import org.openldap.accelerator.impl.sessionRoles.RbacSessionRolesRequestContainer;
import org.openldap.accelerator.impl.sessionRoles.RbacSessionRolesRequestDecorator;
import org.openldap.accelerator.impl.sessionRoles.RbacSessionRolesRequestStatesEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbacSessionRolesRequestGrammar
extends AbstractGrammar<RbacSessionRolesRequestContainer> {
    static final Logger LOG = LoggerFactory.getLogger(RbacSessionRolesRequestGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<RbacSessionRolesRequestContainer> instance = new RbacSessionRolesRequestGrammar();

    private RbacSessionRolesRequestGrammar() {
        this.setName(RbacSessionRolesRequestGrammar.class.getName());
        this.transitions = new GrammarTransition[RbacSessionRolesRequestStatesEnum.LAST_RBAC_SESSION_ROLES_REQ_STATE.ordinal()][256];
        this.transitions[RbacSessionRolesRequestStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)RbacSessionRolesRequestStatesEnum.START_STATE, (Enum)RbacSessionRolesRequestStatesEnum.RBAC_SESSION_ROLES_REQ_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<RbacSessionRolesRequestContainer>("Init RbacSessionRolesRequest"){

            public void action(RbacSessionRolesRequestContainer rbacSessionRolesContainer) {
                RbacSessionRolesRequestDecorator rbacSessionRolesRequestDecorator = new RbacSessionRolesRequestDecorator(LdapApiServiceFactory.getSingleton(), (RbacSessionRolesRequest)new RbacSessionRolesRequestImpl());
                rbacSessionRolesContainer.setRbacSessionRolesRequest(rbacSessionRolesRequestDecorator);
            }
        });
        this.transitions[RbacSessionRolesRequestStatesEnum.RBAC_SESSION_ROLES_REQ_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition((Enum)RbacSessionRolesRequestStatesEnum.RBAC_SESSION_ROLES_REQ_SEQUENCE_STATE, (Enum)RbacSessionRolesRequestStatesEnum.RBAC_SESSION_ROLES_REQ_USER_IDENTITY_STATE, 128, (Action)new GrammarAction<RbacSessionRolesRequestContainer>("Stores userIdentity"){

            public void action(RbacSessionRolesRequestContainer rbacSessionRolesContainer) throws DecoderException {
                BerValue value = rbacSessionRolesContainer.getCurrentTLV().getValue();
                String userIdentity = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("userIdentity = {}", (Object)userIdentity);
                }
                rbacSessionRolesContainer.getRbacSessionRolesRequest().setUserIdentity(userIdentity);
            }
        });
        this.transitions[RbacSessionRolesRequestStatesEnum.RBAC_SESSION_ROLES_REQ_USER_IDENTITY_STATE.ordinal()][129] = new GrammarTransition((Enum)RbacSessionRolesRequestStatesEnum.RBAC_SESSION_ROLES_REQ_USER_IDENTITY_STATE, (Enum)RbacSessionRolesRequestStatesEnum.RBAC_SESSION_ROLES_REQ_SESSION_ID_STATE, 129, (Action)new GrammarAction<RbacSessionRolesRequestContainer>("Stores sessionId"){

            public void action(RbacSessionRolesRequestContainer rbacSessionRolesContainer) throws DecoderException {
                BerValue value = rbacSessionRolesContainer.getCurrentTLV().getValue();
                String sessionId = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("sessionID = " + sessionId);
                }
                rbacSessionRolesContainer.getRbacSessionRolesRequest().setSessionId(sessionId);
                rbacSessionRolesContainer.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<RbacSessionRolesRequestContainer> getInstance() {
        return instance;
    }
}

