package org.openxri.admin.components;

import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.IPageLink;
import org.apache.wicket.markup.html.link.PageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.openxri.admin.webpages.store.AuthorityDetails;
import org.openxri.store.Authority;

public class AuthoritiesListPanel extends Panel {

	private static final long serialVersionUID = -3869020158474018110L;

	public AuthoritiesListPanel(String id, IModel model) {

		super(id, model);

		// create and add components

		this.createListView();
	}

	public AuthoritiesListPanel(String id) {

		super(id);

		// create and add components

		this.createListView();
	}

	private void createListView() {

		this.add(new ListView("authorities") {

			private static final long serialVersionUID = 8715382715578294263L;

			@Override
			protected void populateItem(ListItem item) {

				final Authority authority = (Authority) item.getModelObject();

				PageLink link = new PageLink("link", new IPageLink() {

					private static final long serialVersionUID = 8137543413717092367L;

					public Page getPage() {
						
						return(new AuthorityDetails(authority));
					}

					public Class<?> getPageIdentity() {
						
						return(AuthorityDetails.class);
					}
				});
				
				link.add(new Label("id", authority.getId().toString()));
				item.add(link);
			}
		});
	}
}
