package org.openxri.admin.components;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class NamedHiddenField extends HiddenField {

	private static final long serialVersionUID = 1709954370003473085L;

	protected String name;
	
	public NamedHiddenField(String id, IModel model, String name) {

		super(id, model);
		
		this.name = name;
	}

	public NamedHiddenField(String id, String value, String name) {

		this(id, new Model(value), name);
	}

	@Override
	protected void onComponentTag(ComponentTag tag) {

		super.onComponentTag(tag);

		// add our own name

		tag.put("name", this.name);
	}
}
