package org.openxri.admin.components;

import java.util.ArrayList;
import java.util.Map;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class PropertiesPanel extends Panel {

	private static final long serialVersionUID = 8430803488175700401L;

	public PropertiesPanel(String id, IModel model) {

		super(id);

		// create and add components

		final Map<?, ?> map = (Map<?, ?>) model.getObject();
		
		this.add(new ListView("properties", new ArrayList<Object>(map.keySet())) {

			private static final long serialVersionUID = -6171507661587195670L;

			@Override
			protected void populateItem(ListItem item) {

				String key = item.getModelObject().toString();
				String value = map.get(key).toString();

				item.add(new Label("key", key));
				item.add(new Label("value", value));
			}
		});
	}
}
