package org.openxri.admin.components;

import java.util.List;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;

public class StringListView extends ListView {

	private static final long serialVersionUID = 3850565892148882283L;

	protected String itemId;
	
	public StringListView(String id, String itemId, List<String> list) {

		super(id, list);
		
		this.itemId = itemId;
	}
	
	public StringListView(String id, String itemId, IModel model) {

		super(id, model);
		
		this.itemId = itemId;
	}
	
	public StringListView(String id, String itemId) {

		super(id);
		
		this.itemId = itemId;
	}
	
	@Override
	protected void populateItem(ListItem item) {
		
		item.add(new Label(this.itemId, item.getModelObjectAsString()));
	}
}
