package org.openxri.admin.components;

import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.IPageLink;
import org.apache.wicket.markup.html.link.PageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.openxri.admin.webpages.store.SubSegmentDetails;
import org.openxri.store.SubSegment;

public class SubSegmentsListPanel extends Panel {

	private static final long serialVersionUID = 606359638551115654L;

	public SubSegmentsListPanel(String id, IModel model) {

		super(id, model);

		// create and add components

		this.createListView();
	}

	public SubSegmentsListPanel(String id) {

		super(id);

		// create and add components

		this.createListView();
	}

	private void createListView() {

		this.add(new ListView("subSegments") {

			private static final long serialVersionUID = 5612635419131499932L;

			@Override
			protected void populateItem(ListItem item) {

				final SubSegment subSegment = (SubSegment) item.getModelObject();

				PageLink link = new PageLink("link", new IPageLink() {

					private static final long serialVersionUID = -465660455825345856L;

					public Page getPage() {
						
						return(new SubSegmentDetails(subSegment));
					}

					public Class<?> getPageIdentity() {
						
						return(SubSegmentDetails.class);
					}
					
				});
				
				link.add(new Label("id", subSegment.getId().toString()));
				link.add(new Label("name", subSegment.getName()));
				item.add(link);
			}
		});
	}
}
