package org.openxri.admin.models;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.Application;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.LoadableDetachableModel;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.StoreBetterLookup;

public class AllAuthoritiesModel extends LoadableDetachableModel implements IChoiceRenderer {

	private static final long serialVersionUID = -605535688450064767L;

	private static Log log = LogFactory.getLog(AllAuthoritiesModel.class.getName());

	@Override
	public Object load() {

		List<Authority> list;

		Store openXRIStore = ((OpenXRIAdminApplication) Application.get()).getOpenXRIStore();

		list = new ArrayList<Authority> ();

		// list all authorities

		log.debug("Listing all authorities.");

		try {

			Authority[] rootAuthoritys = ((StoreBetterLookup) openXRIStore).listAuthorities();

			for (Authority rootAuthority : rootAuthoritys) {

				list.add(rootAuthority);
			}
		} catch (Exception ex) {

			log.error("Failed.", ex);
			return(new ArrayList<Authority> ());
		}

		log.debug("Done.");
		return(list);
	}

	public Object getDisplayValue(Object object) {

		Authority rootAuthority = (Authority) object;

		return(rootAuthority.getId().toString());
	}

	public String getIdValue(Object object, int index) {

		return(((Authority) object).getId().toString());
	}
}
