package org.openxri.admin.models;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.Application;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.LoadableDetachableModel;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.store.Store;
import org.openxri.store.SubSegment;

public class RootSubSegmentsModel extends LoadableDetachableModel implements IChoiceRenderer {

	private static final long serialVersionUID = -605535688450064767L;

	private static Log log = LogFactory.getLog(RootSubSegmentsModel.class.getName());

	@Override
	public Object load() {

		List<SubSegment> list;

		Store openXRIStore = ((OpenXRIAdminApplication) Application.get()).getOpenXRIStore();

		list = new ArrayList<SubSegment> ();

		// add all subsegments to the model

		log.debug("Listing all root subsegments.");

		try {

			SubSegment[] rootSubSegments = openXRIStore.listRootSubSegments();

			for (SubSegment rootSubSegment : rootSubSegments) {

				list.add(rootSubSegment);
			}
		} catch (Exception ex) {

			log.error("Failed.", ex);
			return(new ArrayList<SubSegment> ());
		}

		log.debug("Done.");
		return(list);
	}

	public Object getDisplayValue(Object object) {

		SubSegment rootSubSegment = (SubSegment) object;
		
		return(rootSubSegment.getName());
	}

	public String getIdValue(Object object, int index) {

		SubSegment rootSubSegment = (SubSegment) object;
		
		return(rootSubSegment.getName());
	}
}
