package org.openxri.admin.resources;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;

import org.apache.wicket.Application;
import org.apache.wicket.markup.html.image.resource.RenderedDynamicImageResource;
import org.apache.wicket.markup.html.link.ImageMap;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.exceptions.StoreException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.SubSegment;

public class SubSegmentImageResource extends RenderedDynamicImageResource {

	private static final long serialVersionUID = -6682154691595772165L;

	protected static final int IMAGE_WIDTH = 800;
	protected static final int IMAGE_HEIGHT = 300;
	protected static final int IMAGE_PADDING_X = 0;
	protected static final int IMAGE_PADDING_Y = 0;
	protected static final int LEFT = 0 + IMAGE_PADDING_X;
	protected static final int TOP = 0 + IMAGE_PADDING_Y;
	protected static final int RIGHT = IMAGE_WIDTH - IMAGE_PADDING_X;
	protected static final int BOTTOM = IMAGE_HEIGHT - IMAGE_PADDING_Y;
	protected static final int WIDTH = RIGHT - LEFT;
	protected static final int HEIGHT = BOTTOM - TOP;
	protected static final int CENTER_X = IMAGE_WIDTH / 2;
	protected static final int CENTER_Y = IMAGE_HEIGHT / 2;
	protected static final int CENTER_AUTHORITY_WIDTH = 20;
	protected static final int CENTER_AUTHORITY_HEIGHT = 20;
	protected static final int AUTHORITY_WIDTH = 20;
	protected static final int AUTHORITY_HEIGHT = 20;

	protected static final Color AUTHORITY_COLOR = Color.DARK_GRAY;
	protected static final Color LINE_COLOR = new Color(3, 109, 167);
	protected static final Stroke LINE_STROKE = new BasicStroke(3);
	protected static final Color TEXT_COLOR = Color.WHITE;
	protected static final Font TEXT_FONT = new Font("Sans-serif", Font.PLAIN, 10);

	protected Authority parentAuthority;
	protected SubSegment subSegment;
	protected Authority authority;

	public SubSegmentImageResource(SubSegment subSegment) throws StoreException {

		super(IMAGE_WIDTH, IMAGE_HEIGHT, "png");

		final Store openXRIStore = ((OpenXRIAdminApplication) Application.get()).getOpenXRIStore();

		this.subSegment = subSegment;
		this.parentAuthority = openXRIStore.getSubSegmentParentAuthority(subSegment);
		this.authority = openXRIStore.getSubSegmentAuthority(subSegment);
	}

	@Override
	protected boolean render(Graphics2D graphics) {

		graphics.setFont(TEXT_FONT);

		renderSubSegment(graphics);

		return(true);
	}

	protected void renderSubSegment(Graphics2D graphics) {

		int y1, y2;

		y1 = TOP + HEIGHT / 4;
		y2 = TOP + HEIGHT * 3 / 4;

		graphics.setColor(LINE_COLOR);
		graphics.setStroke(LINE_STROKE);
		graphics.drawLine(CENTER_X, y1, CENTER_X, y2);

		graphics.setColor(AUTHORITY_COLOR);
		graphics.setBackground(AUTHORITY_COLOR);
		if (this.parentAuthority == null) {

			graphics.drawOval(CENTER_X - CENTER_AUTHORITY_WIDTH / 2, y1 - CENTER_AUTHORITY_HEIGHT / 2, CENTER_AUTHORITY_WIDTH, CENTER_AUTHORITY_HEIGHT);
		} else {

			graphics.fillOval(CENTER_X - CENTER_AUTHORITY_WIDTH / 2, y1 - CENTER_AUTHORITY_HEIGHT / 2, CENTER_AUTHORITY_WIDTH, CENTER_AUTHORITY_HEIGHT);

			String text;
			if (this.parentAuthority.getXrd().getCanonicalID() != null)
				text = this.parentAuthority.getXrd().getCanonicalID().getValue();
			else
				text = this.parentAuthority.getId().toString();

			write(graphics, text, CENTER_X + 15, y1 - CENTER_AUTHORITY_HEIGHT / 2, false);
		}

		graphics.setColor(AUTHORITY_COLOR);
		graphics.setBackground(AUTHORITY_COLOR);
		if (this.authority == null) {

			graphics.drawOval(CENTER_X - CENTER_AUTHORITY_WIDTH / 2, y2 - CENTER_AUTHORITY_HEIGHT / 2, CENTER_AUTHORITY_WIDTH, CENTER_AUTHORITY_HEIGHT);
		} else {

			graphics.fillOval(CENTER_X - CENTER_AUTHORITY_WIDTH / 2, y2 - CENTER_AUTHORITY_HEIGHT / 2, CENTER_AUTHORITY_WIDTH, CENTER_AUTHORITY_HEIGHT);

			String text;
			if (this.authority.getXrd().getCanonicalID() != null)
				text = this.authority.getXrd().getCanonicalID().getValue();
			else
				text = this.authority.getId().toString();

			write(graphics, text, CENTER_X + 15, y2 - CENTER_AUTHORITY_HEIGHT / 2, false);
		}

		write(graphics, this.subSegment.getName(), CENTER_X + 15, CENTER_Y - 5, false);
	}

	private static void write(Graphics2D graphics, String text, int posX, int posY, boolean center) {

		FontMetrics fontMetrics = graphics.getFontMetrics(TEXT_FONT);

		if (center) posX -= (int) (fontMetrics.getStringBounds(text, graphics).getWidth() / 2);
		if (center) posY -= (int) (fontMetrics.getStringBounds(text, graphics).getHeight() / 2);
		
		graphics.setColor(TEXT_COLOR);
		graphics.drawString(text, posX, posY + fontMetrics.getAscent());
	}

	public ImageMap createImageMap(String id) {

		ImageMap map = new ImageMap(id);

		return(map);
	}
}
