package org.openxri.admin.webapplication;

import java.util.Properties;

import org.apache.wicket.Request;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.spring.SpringWebApplication;
import org.apache.wicket.util.lang.PackageName;
import org.openxri.admin.webpages.error.AccessDenied;
import org.openxri.admin.webpages.error.InternalError;
import org.openxri.admin.webpages.error.PageExpired;
import org.openxri.factories.ServerConfigFactory;
import org.openxri.resolve.Resolver;

public class OpenXRIAdminApplication extends SpringWebApplication {

	protected Properties properties;
	protected org.openxri.config.ServerConfig openXRIServerConfig;
	protected Resolver resolver;

	@Override
	public void init() {

		// init OpenXRI ServletConfig
		
		try {

			this.openXRIServerConfig = ServerConfigFactory.initSingleton(this.getWicketFilter().getFilterConfig());
		} catch (Exception ex) {

			throw new RuntimeException(ex);
		}
		
		// init resolver

		try {

			this.resolver = new Resolver(null);
		} catch (Exception ex) {
			
			throw new RuntimeException(ex);
		}
		
		// set up page mounting

		this.mount("/home", PackageName.forClass(org.openxri.admin.webpages.home.Index.class));
		this.mount("/srvr", PackageName.forClass(org.openxri.admin.webpages.server.Index.class));
		this.mount("/config", PackageName.forClass(org.openxri.admin.webpages.config.Index.class));
		this.mount("/store", PackageName.forClass(org.openxri.admin.webpages.store.Index.class));
		this.mount("/urimapper", PackageName.forClass(org.openxri.admin.webpages.urimapper.Index.class));
		this.mount("/plugin", PackageName.forClass(org.openxri.admin.webpages.plugin.Index.class));
		this.mount("/sorry", PackageName.forClass(AccessDenied.class));

		// set up various wicket parameters

		this.getApplicationSettings().setClassResolver(new OpenXRIAdminClassResolver());
		this.getApplicationSettings().setAccessDeniedPage(AccessDenied.class);
		this.getApplicationSettings().setInternalErrorPage(InternalError.class);
		this.getApplicationSettings().setPageExpiredErrorPage(PageExpired.class);
		this.getSecuritySettings().setAuthorizationStrategy(new OpenXRIAdminAuthorizationStrategy());
		this.getMarkupSettings().setStripXmlDeclarationFromOutput(false);
		this.getMarkupSettings().setDefaultMarkupEncoding("UTF-8");

		// DEVELOPMENT

		/*		this.getMarkupSettings().setStripWicketTags(false);
		this.getMarkupSettings().setStripComments(false);
		this.getResourceSettings().setResourcePollFrequency(Duration.ONE_SECOND);
		this.getDebugSettings().setComponentUseCheck(true);
		this.getDebugSettings().setAjaxDebugModeEnabled(true);*/

		// DEPLOYMENT

		this.getMarkupSettings().setStripWicketTags(true);
		this.getMarkupSettings().setStripComments(true);
		this.getResourceSettings().setResourcePollFrequency(null);
		this.getDebugSettings().setComponentUseCheck(false);
		this.getDebugSettings().setAjaxDebugModeEnabled(false);
	}

	@Override
	public Class<?> getHomePage() {

		return(org.openxri.admin.webpages.home.Index.class);
	}

	@Override
	protected IRequestCycleProcessor newRequestCycleProcessor() {

		return(new OpenXRIAdminRequestCycleProcessor());
	}

	@Override
	public String getConfigurationType() {
		
		return("DEPLOYMENT");
	}
	
	@Override
	public Session newSession(Request request, Response response) {

		return(new OpenXRIAdminSession(request));
	}

	public Properties getProperties() {
		
		return (this.properties);
	}

	public void setProperties(Properties properties) {
		
		this.properties = properties;
	}

	public org.openxri.config.ServerConfig getOpenXRIServerConfig() {
		
		return(this.openXRIServerConfig);
	}

	public void setOpenXRIServerConfig(org.openxri.config.ServerConfig openXRIConfig) {
		
		this.openXRIServerConfig = openXRIConfig;
	}

	public Resolver getResolver() {

		return(this.resolver);
	}

	public void setResolver(Resolver resolver) {

		this.resolver = resolver;
	}

	public org.openxri.urimapper.URIMapper getOpenXRIURIMapper() {

		return((org.openxri.urimapper.URIMapper) this.openXRIServerConfig.getComponentRegistry().getComponent(org.openxri.urimapper.URIMapper.class));
	}

	public org.openxri.plugin.Plugin getOpenXRIPlugin() {
		
		return((org.openxri.plugin.Plugin) this.openXRIServerConfig.getComponentRegistry().getComponent(org.openxri.plugin.Plugin.class));
	}

	public org.openxri.server.Server getOpenXRIServer() {

		return((org.openxri.server.Server) this.openXRIServerConfig.getComponentRegistry().getComponent(org.openxri.server.Server.class));
	}

	public org.openxri.store.Store getOpenXRIStore() {
		
		return((org.openxri.store.Store) this.openXRIServerConfig.getComponentRegistry().getComponent(org.openxri.store.Store.class));
	}
}
