package org.openxri.admin.webpages.components;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.Model;
import org.openxri.admin.components.PropertiesPanel;
import org.openxri.config.Component;

public class ComponentPanel extends Panel {

	private static final long serialVersionUID = 8430803488175700401L;

	public ComponentPanel(String id, Component component) {

		super(id);

		// create and add components

		this.add(new Label("implementation", new Model(component.getClass().getName())));

		this.add(new ListView("interfaces", Arrays.asList(getRecursiveInterfaces(component.getClass()))) {

			private static final long serialVersionUID = -6171507661587195670L;

			@Override
			protected void populateItem(ListItem item) {

				Class<?> clazz = (Class<?>) item.getModelObject();

				item.add(new Label("interface", clazz.getName()));
			}
		});
		
		this.add(new PropertiesPanel("properties", new Model(component.getProperties())));
	}

	public static Class<?>[] getRecursiveInterfaces(Class<?> clazz) {

		Set<Class<?>> set = new HashSet<Class<?>> ();

		getRecursiveInterfaces(clazz, set);

		return(set.toArray(new Class<?>[set.size()]));
	}

	private static void getRecursiveInterfaces(Class<?> clazz, Set<Class<?>> set) {

		for (Class<?> c : clazz.getInterfaces()) {

			set.add(c);
			getRecursiveInterfaces(c, set);
		}

		Class<?> c = clazz.getSuperclass();
		if (c != null) getRecursiveInterfaces(c, set);
	}

}
