package org.openxri.admin.webpages.config;

import java.util.ArrayList;
import java.util.List;

import org.apache.wicket.Application;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.Model;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.config.ServerConfig;

public class Index extends BasePage {

	private static final long serialVersionUID = 2297749911034720192L;

	private ListView configEntriesListView; 

	@SuppressWarnings("unchecked")
	public Index() {

		this.setTitle(this.getString("title"));

		final ServerConfig openXRIConfig = ((OpenXRIAdminApplication) Application.get()).getOpenXRIServerConfig();
		
		// create and add components

		this.add(new Label("clazz", openXRIConfig.getClass().getName()));
		
		List<Object> keys = new ArrayList<Object> (openXRIConfig.getProperties().keySet());
		
		this.configEntriesListView = new ListView("configEntries", keys) {

			private static final long serialVersionUID = 4268418431817371342L;

			@Override
			protected void populateItem(ListItem item) {

				// create and add components

				String key = item.getModelObjectAsString();
				String value = openXRIConfig.getProperties().getProperty(key);

				item.add(new Label("configKey", new Model(key)));
				item.add(new Label("configValue", new Model(value)));
			}
		};

		this.add(this.configEntriesListView);
	}
}
