package org.openxri.admin.webpages.home;

import org.apache.wicket.Application;
import org.apache.wicket.markup.html.basic.Label;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.config.ServerConfig;

public class Index extends BasePage {

	private static final long serialVersionUID = -597481320422867019L;

	public Index() {

		this.setTitle(this.getString("title"));

		ServerConfig openXRIConfig = ((OpenXRIAdminApplication) Application.get()).getOpenXRIServerConfig();

		// create and add components

		String serverUrl = openXRIConfig.getHostName() + ":" + openXRIConfig.getHostPort() + openXRIConfig.getServletPath();
		this.add(new Label("serverUrl", serverUrl));
	}
}
