package org.openxri.admin.webpages.pipelines;

import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.pipeline.Pipeline;

public class Index extends BasePage {

	private static final long serialVersionUID = -597481320422867019L;

	public Index() {

		this.setTitle(this.getString("title"));

		// create and add components

		this.add(new ListView("pipelines", ((OpenXRIAdminApplication) this.getApplication()).getOpenXRIServerConfig().getPipelineRegistry().getPipelines()) {

			private static final long serialVersionUID = 6099999471694144186L;

			@Override
			protected void populateItem(ListItem item) {
				
				Pipeline pipeline = (Pipeline) item.getModelObject();
				
				item.add(new PipelinePanel("pipeline", pipeline));
			}
		});
	}
}
