package org.openxri.admin.webpages.server;

import org.apache.wicket.Application;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.Model;
import org.openxri.admin.models.RootSubSegmentsModel;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.exceptions.ServerNotFoundException;
import org.openxri.server.Server;
import org.openxri.store.SubSegment;
import org.openxri.xml.XRDS;

public class Index extends BasePage {

	private static final long serialVersionUID = -597481320422867019L;
	private static final String DEFAULT_QUERY = "*";
	private static final Boolean DEFAULT_SIGNED = Boolean.FALSE;

	private ServerForm serverForm;
	private ServerFormSelf serverFormSelf;
	private ServerResultFragment serverResultFragment;

	public Index() {

		this.setTitle(this.getString("title"));

		// create and add components

		this.serverForm = new ServerForm("serverForm");
		this.serverFormSelf = new ServerFormSelf("serverFormSelf");
		this.serverResultFragment = new ServerResultFragment("serverResultPanel", "serverResultFragment", this);
		this.serverResultFragment.setVisible(false);

		this.add(this.serverForm);
		this.add(this.serverFormSelf);
		this.add(this.serverResultFragment);
	}

	private class ServerForm extends Form {

		private static final long serialVersionUID = 3501067102210565000L;

		private SubSegment rootSubSegment;
		private String query = DEFAULT_QUERY;
		private Boolean signed = DEFAULT_SIGNED;

		public ServerForm(String id) {

			super(id);
			this.setModel(new CompoundPropertyModel(this));

			// create components

			RootSubSegmentsModel rootSubSegmentsModel = new RootSubSegmentsModel();

			DropDownChoice rootSubSegmentsDropDownChoice;
			TextField queryTextField;

			rootSubSegmentsDropDownChoice = new DropDownChoice("rootSubSegment", rootSubSegmentsModel, (IChoiceRenderer) rootSubSegmentsModel);
			rootSubSegmentsDropDownChoice.setLabel(new Model("Root namespace"));
			rootSubSegmentsDropDownChoice.setRequired(true);

			queryTextField = new TextField("query");
			queryTextField.setLabel(new Model("Query"));
			queryTextField.setRequired(true);

			// create and add components

			this.add(rootSubSegmentsDropDownChoice);
			this.add(queryTextField);
			this.add(new CheckBox("signed"));
		}

		public String getQuery() {
			return (this.query);
		}
		public void setQuery(String query) {
			this.query = query;
		}
		public SubSegment getRootSubSegment() {
			return (this.rootSubSegment);
		}
		public void setRootSubSegment(SubSegment rootSubSegment) {
			this.rootSubSegment = rootSubSegment;
		}
		public Boolean getSigned() {
			return (this.signed);
		}
		public void setSigned(Boolean signed) {
			this.signed = signed;
		}

		@Override
		protected void onSubmit() {

			Server openXRIServer = ((OpenXRIAdminApplication) Application.get()).getOpenXRIServer();

			try {

				XRDS xrds = openXRIServer.lookupByNamespace(
						this.rootSubSegment.getName(), 
						this.query, 
						this.signed.booleanValue());

				if (xrds == null) throw new ServerNotFoundException();
				
				Index.this.serverResultFragment.setXrds(xrds);
			} catch (ServerNotFoundException ex) {

				Index.this.error(Index.this.getString("servernotfound"));
				Index.this.serverResultFragment.setVisible(false);
				return;
			} catch (Exception ex) {

				Index.this.error(Index.this.getString("serverfail") + ex.getLocalizedMessage());
				Index.this.serverResultFragment.setVisible(false);
				return;
			}

			Index.this.serverResultFragment.setVisible(true);
		}
	}

	private class ServerFormSelf extends Form {

		private static final long serialVersionUID = 7795569774706971160L;
		
		private SubSegment rootSubSegment;
		private Boolean signed = DEFAULT_SIGNED;

		public ServerFormSelf(String id) {

			super(id);
			this.setModel(new CompoundPropertyModel(this));

			// create components

			RootSubSegmentsModel rootSubSegmentsModel = new RootSubSegmentsModel();

			DropDownChoice rootSubSegmentsDropDownChoice;

			rootSubSegmentsDropDownChoice = new DropDownChoice("rootSubSegment", rootSubSegmentsModel, (IChoiceRenderer) rootSubSegmentsModel);
			rootSubSegmentsDropDownChoice.setLabel(new Model("Root namespace"));
			rootSubSegmentsDropDownChoice.setRequired(true);

			// create and add components

			this.add(rootSubSegmentsDropDownChoice);
			this.add(new CheckBox("signed"));
		}

		public SubSegment getRootSubSegment() {
			return (this.rootSubSegment);
		}
		public void setRootSubSegment(SubSegment rootSubSegment) {
			this.rootSubSegment = rootSubSegment;
		}
		public Boolean getSigned() {
			return (this.signed);
		}
		public void setSigned(Boolean signed) {
			this.signed = signed;
		}

		@Override
		protected void onSubmit() {

			Server openXRIServer = ((OpenXRIAdminApplication) Application.get()).getOpenXRIServer();

			try {

				XRDS xrds = openXRIServer.lookupSelfDescribing(
						this.rootSubSegment.getName(), 
						this.signed.booleanValue());

				if (xrds == null) throw new ServerNotFoundException();
				
				Index.this.serverResultFragment.setXrds(xrds);
			} catch (ServerNotFoundException ex) {

				Index.this.error(Index.this.getString("servernotfound"));
				Index.this.serverResultFragment.setVisible(false);
				return;
			} catch (Exception ex) {

				Index.this.error(Index.this.getString("serverfail") + ex.getLocalizedMessage());
				Index.this.serverResultFragment.setVisible(false);
				return;
			}

			Index.this.serverResultFragment.setVisible(true);
		}
	}

	private class ServerResultFragment extends Fragment {

		private static final long serialVersionUID = 6148514263284960328L;

		private XRDS xrds;

		public ServerResultFragment(String id, String markupId, MarkupContainer markupContainer) {

			super(id, markupId, markupContainer);
			this.setModel(new CompoundPropertyModel(this));

			// create and add components

			this.add(new Label("xrds"));
		}

		public XRDS getXrds() {
			return (this.xrds);
		}
		public void setXrds(XRDS xrds) {
			this.xrds = xrds;
		}
	}
}
