package org.openxri.admin.webpages.store;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.PageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.Model;
import org.openxri.admin.models.AllAuthoritiesModel;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.exceptions.StoreException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.SubSegment;

public class CreateAliasSubSegment extends BasePage {

	private static final long serialVersionUID = -1319657998507001340L;
	private static final String DEFAULT_SUBSEGMENT_NAME = "*";

	private static final Log log = LogFactory.getLog(CreateAliasSubSegment.class);

	private CreateAliasSubSegmentForm form;
	
	public CreateAliasSubSegment() {

		this.setTitle(this.getString("title"));

		// create and add components

		this.form = new CreateAliasSubSegmentForm("createAliasSubSegmentForm");
		
		this.add(this.form);
		this.add(new PageLink("backLink", Index.class));
	}

	public CreateAliasSubSegment(Authority parentAuthority) {
		
		this();
		
		this.form.setParentAuthority(parentAuthority);
	}

	public CreateAliasSubSegment(Authority parentAuthority, Authority authority) {
		
		this();
		
		this.form.setParentAuthority(parentAuthority);
		this.form.setAuthority(authority);
	}
	
	private class CreateAliasSubSegmentForm extends Form {

		private static final long serialVersionUID = -8467960396699989808L;

		private Authority parentAuthority;
		private String name = DEFAULT_SUBSEGMENT_NAME;
		private Authority authority;

		public CreateAliasSubSegmentForm(String id) {

			super(id);
			this.setModel(new CompoundPropertyModel(this));

			// create

			AllAuthoritiesModel allAuthoritiesModel = new AllAuthoritiesModel();

			DropDownChoice parentAuthorityDropDownChoice;
			DropDownChoice authorityDropDownChoice;
			TextField nameTextField;
			
			parentAuthorityDropDownChoice = new DropDownChoice("parentAuthority", allAuthoritiesModel, (IChoiceRenderer) allAuthoritiesModel);
			parentAuthorityDropDownChoice.setLabel(new Model("Parent Authority"));
			
			authorityDropDownChoice = new DropDownChoice("authority", allAuthoritiesModel, (IChoiceRenderer) allAuthoritiesModel);
			authorityDropDownChoice.setLabel(new Model("Authority"));
			authorityDropDownChoice.setRequired(true);

			nameTextField = new TextField("name");
			nameTextField.setLabel(new Model("Subsegment name"));
			nameTextField.setRequired(true);
			
			// add components
			
			this.add(parentAuthorityDropDownChoice);
			this.add(nameTextField);
			this.add(authorityDropDownChoice);
		}

		public String getName() {
			return (this.name);
		}

		public void setName(String name) {
			this.name = name;
		}

		public Authority getParentAuthority() {
			return (this.parentAuthority);
		}

		public void setParentAuthority(Authority parentAuthority) {
			this.parentAuthority = parentAuthority;
		}
		
		public Authority getAuthority() {
			return (this.authority);
		}

		public void setAuthority(Authority authority) {
			this.authority = authority;
		}

		@Override
		protected void onSubmit() {

			final Store openXRIStore = ((OpenXRIAdminApplication) this.getApplication()).getOpenXRIStore();

			SubSegment subSegment;
			
			try {

				subSegment = openXRIStore.registerSubsegment(
						this.parentAuthority, 
						this.name, 
						this.authority);
			} catch (StoreException ex) {

				CreateAliasSubSegment.log.error(ex);
				CreateAliasSubSegment.this.error(CreateAliasSubSegment.this.getString("storefail") + ex.getLocalizedMessage());
				return;
			}

			// go to details of the new subsegment

			this.setResponsePage(new SubSegmentDetails(subSegment));
		}
	}
}
