package org.openxri.admin.webpages.store;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.PageLink;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.exceptions.StoreException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.xml.XRD;

public class CreateAuthority extends BasePage {

	private static final long serialVersionUID = 1209589157235509150L;

	private static final Log log = LogFactory.getLog(CreateAuthority.class);

	private CreateAuthorityForm form;
	
	public CreateAuthority() {

		this.setTitle(this.getString("title"));

		// create and add components

		this.form = new CreateAuthorityForm("createAuthorityForm");
		
		this.add(this.form);
		this.add(new PageLink("backLink", Index.class));
	}

	private class CreateAuthorityForm extends Form {

		private static final long serialVersionUID = 2622570754273118524L;

		public CreateAuthorityForm(String id) {

			super(id);
		}

		@Override
		protected void onSubmit() {

			final Store openXRIStore = ((OpenXRIAdminApplication) this.getApplication()).getOpenXRIStore();

			XRD xrd = new XRD();
			Authority authority;
			
			try {

				authority = openXRIStore.createAuthority(xrd);
			} catch (StoreException ex) {

				CreateAuthority.log.error(ex);
				CreateAuthority.this.error(CreateAuthority.this.getString("storefail") + ex.getLocalizedMessage());
				return;
			}

			// go to details of the new authority

			this.setResponsePage(new AuthorityDetails(authority));
		}
	}
}
