package org.openxri.admin.webpages.store;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.PageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.openxri.XRI;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.exceptions.StoreException;
import org.openxri.resolve.Resolver;
import org.openxri.resolve.ResolverFlags;
import org.openxri.resolve.ResolverState;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.StoreEditable;
import org.openxri.store.SubSegment;
import org.openxri.xml.CanonicalID;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;

public class CreateRootNamespace extends BasePage {

	private static final long serialVersionUID = 5529090374026849299L;

	private static final Log log = LogFactory.getLog(CreateRootNamespace.class);

	private final String _storefail = this.getString("storefail");
	private final String _success = this.getString("success");

	public CreateRootNamespace() {

		this.setTitle(this.getString("title"));

		// create and add components

		this.add(new CreateRootNamespaceForm("createRootNamespaceForm"));
		this.add(new PageLink("backLink", Index.class));
	}

	private class CreateRootNamespaceForm extends Form {

		private static final long serialVersionUID = -1852614980935432265L;

		private String namespace;

		public CreateRootNamespaceForm(String id) {

			super(id);
			this.setModel(new CompoundPropertyModel(this));

			// create and add components

			this.add(new TextField("namespace").setRequired(true));
		}

		public String getNamespace() {
			return (this.namespace);
		}

		public void setNamespace(String namespace) {
			this.namespace = namespace;
		}

		@Override
		protected void onSubmit() {

			final Store openXRIStore = ((OpenXRIAdminApplication) this.getApplication()).getOpenXRIStore();
			final Resolver resolver = ((OpenXRIAdminApplication) this.getApplication()).getResolver();

			try {

				SubSegment rootSubSegment = openXRIStore.createRootSubSegment(this.namespace, new XRD());

				CanonicalID canonicalID;
				Authority authority;

				try {

					authority = openXRIStore.getSubSegmentAuthority(rootSubSegment);

					XRDS xrds = resolver.resolveAuthority(new XRI(this.namespace), new ResolverFlags(), new ResolverState());
					XRD xrd = (xrds != null) ? xrds.getFinalXRD() : null;
					canonicalID = (xrd != null) ? xrd.getCanonicalID() : null;
				} catch (Exception ex) {

					log.warn("Cannot find corresponding i-number");
					canonicalID = null;
					authority = null;
				}

				if (canonicalID != null && authority != null && ! canonicalID.getValue().equals(this.namespace)) {

					XRD xrd = authority.getXrd();
					xrd.setCanonicalID(new CanonicalID(canonicalID.getValue()));

					((StoreEditable) openXRIStore).setXrd(authority, xrd);
					openXRIStore.registerSubsegment(null, canonicalID.getValue(), authority);
				}
			} catch (StoreException ex) {

				CreateRootNamespace.log.error(ex);
				CreateRootNamespace.this.error(CreateRootNamespace.this._storefail + ex.getLocalizedMessage());
				return;
			}

			CreateRootNamespace.this.info(CreateRootNamespace.this._success);
		}
	}
}
