package org.openxri.admin.webpages.store;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.PageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.Model;
import org.openxri.admin.models.AllAuthoritiesModel;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.exceptions.StoreException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.SubSegment;
import org.openxri.xml.XRD;

public class CreateSubSegment extends BasePage {

	private static final long serialVersionUID = 5529090374026849299L;
	private static final String DEFAULT_SUBSEGMENT_NAME = "*";

	private static final Log log = LogFactory.getLog(CreateSubSegment.class);

	private CreateSubSegmentForm form;
	
	public CreateSubSegment() {

		this.setTitle(this.getString("title"));

		// create and add components

		this.form = new CreateSubSegmentForm("createSubSegmentForm");
		
		this.add(this.form);
		this.add(new PageLink("backLink", Index.class));
	}

	public CreateSubSegment(Authority parentAuthority) {
		
		this();
		
		this.form.setParentAuthority(parentAuthority);
	}
	
	private class CreateSubSegmentForm extends Form {

		private static final long serialVersionUID = -1852614980935432265L;

		private Authority parentAuthority;
		private String name = DEFAULT_SUBSEGMENT_NAME;

		public CreateSubSegmentForm(String id) {

			super(id);
			this.setModel(new CompoundPropertyModel(this));

			// create components

			AllAuthoritiesModel allAuthoritiesModel = new AllAuthoritiesModel();
			
			DropDownChoice parentAuthorityDropDownChoice;
			TextField nameTextField;
			
			parentAuthorityDropDownChoice = new DropDownChoice("parentAuthority", allAuthoritiesModel, (IChoiceRenderer) allAuthoritiesModel);
			parentAuthorityDropDownChoice.setLabel(new Model("Parent Authority"));

			nameTextField = new TextField("name");
			nameTextField.setLabel(new Model("Subsegment name"));
			nameTextField.setRequired(true);
			
			// add components
			
			this.add(parentAuthorityDropDownChoice);
			this.add(nameTextField);
		}

		public String getName() {
			return (this.name);
		}

		public void setName(String name) {
			this.name = name;
		}

		public Authority getParentAuthority() {
			return (this.parentAuthority);
		}

		public void setParentAuthority(Authority parentAuthority) {
			this.parentAuthority = parentAuthority;
		}

		@Override
		protected void onSubmit() {

			final Store openXRIStore = ((OpenXRIAdminApplication) this.getApplication()).getOpenXRIStore();

			SubSegment subSegment;
			Authority authority;
			
			try {

				XRD xrd = new XRD();
				
				subSegment = openXRIStore.registerSubsegment(
						this.parentAuthority, 
						this.name, 
						xrd);
				
				authority = openXRIStore.getSubSegmentAuthority(subSegment);
			} catch (StoreException ex) {

				CreateSubSegment.log.error(ex);
				CreateSubSegment.this.error(CreateSubSegment.this.getString("storefail") + ex.getLocalizedMessage());
				return;
			}

			// go to details of the new authority

			this.setResponsePage(new AuthorityDetails(authority));
		}
	}
}
