package org.openxri.admin.webpages.store;

import org.apache.wicket.markup.html.link.PageLink;
import org.openxri.admin.webpages.BasePage;

public class Index extends BasePage {

	private static final long serialVersionUID = 2683259805027819720L;

	public Index() {

		this.setTitle(this.getString("title"));

		// create and add components

		this.add(new PageLink("createRootNamespaceLink", CreateRootNamespace.class));
		this.add(new PageLink("listRootNamespacesLink", ListRootNamespaces.class));
		this.add(new PageLink("listAuthoritiesLink", ListAuthorities.class));
		this.add(new PageLink("listSubSegmentsLink", ListSubSegments.class));
		this.add(new PageLink("createSubSegmentLink", CreateSubSegment.class));

		this.add(new PageLink("createAuthorityLink", CreateAuthority.class));
		this.add(new PageLink("createAliasSubSegmentLink", CreateAliasSubSegment.class));
		this.add(new PageLink("listAuthoritiesByIndexLink", ListAuthoritiesByIndex.class));
		this.add(new PageLink("listSubSegmentsByIndexLink", ListSubSegmentsByIndex.class));
		this.add(new PageLink("listAuthoritiesByPathLink", ListAuthoritiesByPath.class));
		this.add(new PageLink("statisticsLink", Statistics.class));
		this.add(new PageLink("resetLink", Reset.class));
	}
}
