package org.openxri.admin.webpages.store;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.markup.html.link.PageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.openxri.admin.components.AuthoritiesListPanel;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.exceptions.StoreException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.StoreBetterLookup;

public class ListAuthorities extends BasePage {

	private static final long serialVersionUID = -1037291139973235893L;

	private static final Log log = LogFactory.getLog(ListAuthorities.class);

	private List<Authority> authorities;

	public ListAuthorities() {

		final Store openXRIStore = ((OpenXRIAdminApplication) this.getApplication()).getOpenXRIStore();

		this.setTitle(this.getString("title"));
		this.setModel(new CompoundPropertyModel(this));

		// get information from the store

		this.authorities = new Vector<Authority> ();

		try {

			this.authorities = Arrays.asList(((StoreBetterLookup) openXRIStore).listAuthorities());
		} catch (StoreException ex) {

			log.error(ex);
			this.error(this.getString("storefail") + ex.getLocalizedMessage());
		}

		log.debug("Authorities: " + this.authorities.size());

		// create and add components

		this.add(new AuthoritiesListPanel("authorities"));
		this.add(new PageLink("backLink", Index.class));
	}

	public List<Authority> getAuthorities() {
		return (this.authorities);
	}

	public void setAuthorities(List<Authority> authorities) {
		this.authorities = authorities;
	}
}
