package org.openxri.admin.webpages.store;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.PageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.Model;
import org.openxri.admin.components.AuthoritiesListPanel;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.exceptions.StoreException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.StoreAttributable;

public class ListAuthoritiesByIndex extends BasePage {

	private static final long serialVersionUID = -1037291139973235893L;

	private static final Log log = LogFactory.getLog(ListAuthoritiesByIndex.class);

	private ResultFragment resultFragment;

	private List<Authority> authorities;

	public ListAuthoritiesByIndex() {

		this.setTitle(this.getString("title"));

		// create and add components

		this.resultFragment = new ResultFragment("resultPanel", "resultFragment", this);
		this.resultFragment.setVisible(false);
		this.add(this.resultFragment);
		this.add(new IndexForm("indexForm"));
		this.add(new PageLink("backLink", Index.class));
	}

	public List<Authority> getAuthorities() {
		return (this.authorities);
	}

	public void setAuthorities(List<Authority> authorities) {
		this.authorities = authorities;
	}

	private class IndexForm extends Form {

		private static final long serialVersionUID = -5939025477270406687L;

		private String index;

		public IndexForm(String id) {

			super(id);
			this.setModel(new CompoundPropertyModel(this));

			// create and add components

			this.add(new TextField("index").setLabel(new Model("Index")).setRequired(true));
		}

		public String getIndex() {
			return (this.index);
		}

		public void setIndex(String index) {
			this.index = index;
		}

		@Override
		protected void onSubmit() {

			final Store openXRIStore = ((OpenXRIAdminApplication) this.getApplication()).getOpenXRIStore();

			// find authorities in store

			try {

				ListAuthoritiesByIndex.this.authorities = Arrays.asList(((StoreAttributable) openXRIStore).listAuthoritiesByIndex(IndexForm.this.index));
			} catch (StoreException ex) {

				ListAuthoritiesByIndex.log.error(ex);
				ListAuthoritiesByIndex.this.error(ListAuthoritiesByIndex.this.getString("storefail") + ex.getLocalizedMessage());
				return;
			}

			// nothing found?

			if (ListAuthoritiesByIndex.this.authorities.size() < 1) {

				ListAuthoritiesByIndex.this.info(ListAuthoritiesByIndex.this.getString("notfound"));
				ListAuthoritiesByIndex.this.resultFragment.setVisible(false);
				return;
			}

			// make result visible

			ListAuthoritiesByIndex.this.resultFragment.setVisible(true);
		}
	}

	private class ResultFragment extends Fragment {

		private static final long serialVersionUID = -5700835271577167173L;

		public ResultFragment(String id, String markupId, MarkupContainer markupContainer) {

			super(id, markupId, markupContainer);
			this.setModel(new CompoundPropertyModel(ListAuthoritiesByIndex.this));

			// create and add components

			this.add(new AuthoritiesListPanel("authorities"));
			this.add(new ResetForm("resetForm"));
		}

		private class ResetForm extends Form {

			private static final long serialVersionUID = -1413650827735818698L;

			public ResetForm(String id) {

				super(id);
			}

			@Override
			protected void onSubmit() {

				ListAuthoritiesByIndex.this.resultFragment.setVisible(false);
			}
		}
	}
}
