package org.openxri.admin.webpages.store;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.PageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.Model;
import org.openxri.admin.components.AuthoritiesListPanel;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.exceptions.StoreException;
import org.openxri.store.Authority;
import org.openxri.store.Store;
import org.openxri.store.StoreMountable;

public class ListAuthoritiesByPath extends BasePage {

	private static final long serialVersionUID = -6110371494342854423L;

	private static final Log log = LogFactory.getLog(ListAuthoritiesByPath.class);

	private ResultFragment resultFragment;

	private List<Authority> authorities;

	public ListAuthoritiesByPath() {

		this.setTitle(this.getString("title"));

		// create and add components

		this.resultFragment = new ResultFragment("resultPanel", "resultFragment", this);
		this.resultFragment.setVisible(false);
		this.add(this.resultFragment);
		this.add(new PathForm("pathForm"));
		this.add(new PageLink("backLink", Index.class));
	}

	public List<Authority> getAuthorities() {
		return (this.authorities);
	}

	public void setAuthorities(List<Authority> authorities) {
		this.authorities = authorities;
	}

	private class PathForm extends Form {

		private static final long serialVersionUID = -4184435582862234474L;

		private String pth;

		public PathForm(String id) {

			super(id);
			this.setModel(new CompoundPropertyModel(this));

			// create and add components

			this.add(new TextField("pth").setLabel(new Model("Mount Path")).setRequired(true));
		}

		public String getPth() {
			return (this.pth);
		}

		public void setPth(String pth) {
			this.pth = pth;
		}

		@Override
		protected void onSubmit() {

			final Store openXRIStore = ((OpenXRIAdminApplication) this.getApplication()).getOpenXRIStore();

			// find authorities in store

			try {

				ListAuthoritiesByPath.this.authorities = Arrays.asList(((StoreMountable) openXRIStore).listAuthoritiesByPath(PathForm.this.pth));
			} catch (StoreException ex) {

				ListAuthoritiesByPath.log.error(ex);
				ListAuthoritiesByPath.this.error(ListAuthoritiesByPath.this.getString("storefail") + ex.getLocalizedMessage());
				return;
			}

			// nothing found?

			if (ListAuthoritiesByPath.this.authorities.size() < 1) {

				ListAuthoritiesByPath.this.info(ListAuthoritiesByPath.this.getString("notfound"));
				ListAuthoritiesByPath.this.resultFragment.setVisible(false);
				return;
			}

			// make result visible

			ListAuthoritiesByPath.this.resultFragment.setVisible(true);
		}
	}

	private class ResultFragment extends Fragment {

		private static final long serialVersionUID = -5700835271577167173L;

		public ResultFragment(String id, String markupId, MarkupContainer markupContainer) {

			super(id, markupId, markupContainer);
			this.setModel(new CompoundPropertyModel(ListAuthoritiesByPath.this));

			// create and add components

			this.add(new AuthoritiesListPanel("authorities"));
			this.add(new ResetForm("resetForm"));
		}

		private class ResetForm extends Form {

			private static final long serialVersionUID = -1413650827735818698L;

			public ResetForm(String id) {

				super(id);
			}

			@Override
			protected void onSubmit() {

				ListAuthoritiesByPath.this.resultFragment.setVisible(false);
			}
		}
	}
}
