package org.openxri.admin.webpages.store;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.markup.html.link.PageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.openxri.admin.components.SubSegmentsListPanel;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.exceptions.StoreException;
import org.openxri.store.Store;
import org.openxri.store.StoreBetterLookup;
import org.openxri.store.SubSegment;

public class ListSubSegments extends BasePage {

	private static final Log log = LogFactory.getLog(ListSubSegments.class);

	private static final long serialVersionUID = 2683259805027819720L;

	private List<SubSegment> subSegments;
	
	public ListSubSegments() {
		
		this.setTitle(this.getString("title"));
		this.setModel(new CompoundPropertyModel(this));

		final Store openXRIStore = ((OpenXRIAdminApplication) this.getApplication()).getOpenXRIStore();

		// get information from the store

		this.subSegments = new Vector<SubSegment> ();
		
		try {

			this.subSegments = Arrays.asList(((StoreBetterLookup) openXRIStore).listSubSegments());
		} catch (StoreException ex) {

			log.error(ex);
			this.error(this.getString("storefail") + ex.getLocalizedMessage());
		}

		// create and add components
		
		this.add(new SubSegmentsListPanel("subSegments"));
		this.add(new PageLink("backLink", Index.class));
	}

	public List<SubSegment> getSubSegments() {
		return (this.subSegments);
	}

	public void setSubSegments(List<SubSegment> subSegments) {
		this.subSegments = subSegments;
	}
}
