package org.openxri.admin.webpages.store;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.PageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.Model;
import org.openxri.admin.components.SubSegmentsListPanel;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.exceptions.StoreException;
import org.openxri.store.Store;
import org.openxri.store.StoreAttributable;
import org.openxri.store.SubSegment;

public class ListSubSegmentsByIndex extends BasePage {

	private static final long serialVersionUID = -1378753791099054850L;

	private static final Log log = LogFactory.getLog(ListSubSegmentsByIndex.class);

	private ResultFragment resultFragment;

	private List<SubSegment> subSegments;
	
	public ListSubSegmentsByIndex() {
		
		this.setTitle(this.getString("title"));

		// create and add components

		this.resultFragment = new ResultFragment("resultPanel", "resultFragment", this);
		this.resultFragment.setVisible(false);
		this.add(this.resultFragment);
		this.add(new IndexForm("indexForm"));
		this.add(new PageLink("backLink", Index.class));
	}

	public List<SubSegment> getSubSegments() {
		return (this.subSegments);
	}

	public void setSubSegments(List<SubSegment> subSegments) {
		this.subSegments = subSegments;
	}
	
	private class IndexForm extends Form {

		private static final long serialVersionUID = 8982281545324851719L;

		private String index;
		
		public IndexForm(String id) {

			super(id);
			this.setModel(new CompoundPropertyModel(this));
			
			// create and add components
			
			this.add(new TextField("index").setLabel(new Model("Index")).setRequired(true));
		}

		public String getIndex() {
			return (this.index);
		}

		public void setIndex(String index) {
			this.index = index;
		}

		@Override
		protected void onSubmit() {

			final Store openXRIStore = ((OpenXRIAdminApplication) this.getApplication()).getOpenXRIStore();

			// find subsegments in store
			
			try {

				ListSubSegmentsByIndex.this.subSegments = Arrays.asList(((StoreAttributable) openXRIStore).listSubSegmentsByIndex(IndexForm.this.index));
			} catch (StoreException ex) {

				ListSubSegmentsByIndex.log.error(ex);
				ListSubSegmentsByIndex.this.error(ListSubSegmentsByIndex.this.getString("storefail") + ex.getLocalizedMessage());
				return;
			}
			
			// nothing found?
			
			if (ListSubSegmentsByIndex.this.subSegments.size() < 1) {
				
				ListSubSegmentsByIndex.this.info(ListSubSegmentsByIndex.this.getString("notfound"));
				ListSubSegmentsByIndex.this.resultFragment.setVisible(false);
				return;
			}
			
			// make result visible
			
			ListSubSegmentsByIndex.this.resultFragment.setVisible(true);
		}
	}
	
	private class ResultFragment extends Fragment {

		private static final long serialVersionUID = -5700835271577167173L;

		public ResultFragment(String id, String markupId, MarkupContainer markupContainer) {

			super(id, markupId, markupContainer);
			this.setModel(new CompoundPropertyModel(ListSubSegmentsByIndex.this));

			// create and add components

			this.add(new SubSegmentsListPanel("subSegments"));
			this.add(new ResetForm("resetForm"));
		}
		
		private class ResetForm extends Form {

			private static final long serialVersionUID = -1413650827735818698L;

			public ResetForm(String id) {

				super(id);
			}

			@Override
			protected void onSubmit() {
				
				ListSubSegmentsByIndex.this.resultFragment.setVisible(false);
			}
		}
	}
}
