package org.openxri.admin.webpages.store;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.openxri.admin.components.EmptyComponent;
import org.openxri.admin.webapplication.OpenXRIAdminApplication;
import org.openxri.admin.webpages.BasePage;
import org.openxri.exceptions.StoreException;
import org.openxri.store.Store;
import org.openxri.store.StoreResettable;

public class Reset extends BasePage {

	private static final long serialVersionUID = 1491737826886882821L;

	private static final Log log = LogFactory.getLog(Reset.class);

	public Reset() {

		this.setTitle(this.getString("title"));

		// create and add components

		this.add(new ResetForm("reset"));
	}

	private class ResetForm extends Form {

		private static final long serialVersionUID = 7146529434598388530L;

		public ResetForm(String id) {

			super(id);

			// create and add components

			this.add(new YesButton("yes"));
			this.add(new NoButton("no"));
		}

		private class YesButton extends Button {

			private static final long serialVersionUID = 2231977060293063722L;

			public YesButton(String id) {

				super(id);
			}

			@Override
			public void onSubmit() {

				final Store openXRIStore = ((OpenXRIAdminApplication) this.getApplication()).getOpenXRIStore();

				// reset the store

				try {

					((StoreResettable) openXRIStore).resetStore();
				} catch (StoreException ex) {

					Reset.log.error(ex);
					this.error(this.getString("storefail") + ex.getLocalizedMessage());

					this.add(new EmptyComponent("authorities"));
				}

				// back to store index

				Reset.this.setResponsePage(Index.class);
			}
		}

		private class NoButton extends Button {

			private static final long serialVersionUID = 4319316477105610910L;

			public NoButton(String id) {

				super(id);
			}

			@Override
			public void onSubmit() {

				// back to store index

				Reset.this.setResponsePage(Index.class);
			}
		}
	}
}
